/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.NoteData;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.NoteInputDialog;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.util.KeyPressReleaseListener;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class AddNoteAction
extends MapMode
implements KeyPressReleaseListener {
    private final transient NoteData noteData;

    public AddNoteAction(NoteData data) {
        super(I18n.tr("Add a new Note", new Object[0]), "addnote", I18n.tr("Add note mode", new Object[0]), ImageProvider.getCursor("crosshair", "create_note"));
        this.noteData = Objects.requireNonNull(data, "data");
    }

    @Override
    public String getModeHelpText() {
        return I18n.tr("Click the location where you wish to create a new note", new Object[0]);
    }

    @Override
    public void enterMode() {
        super.enterMode();
        MapFrame map = MainApplication.getMap();
        map.mapView.addMouseListener(this);
        map.keyDetector.addKeyListener(this);
    }

    @Override
    public void exitMode() {
        super.exitMode();
        MapFrame map = MainApplication.getMap();
        map.mapView.removeMouseListener(this);
        map.keyDetector.removeKeyListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        MapFrame map = MainApplication.getMap();
        map.selectMapMode(map.mapModeSelect);
        NoteInputDialog dialog = new NoteInputDialog((Component)MainApplication.getMainFrame(), I18n.tr("Create a new note", new Object[0]), I18n.tr("Create note", new Object[0]));
        dialog.showNoteDialog(I18n.tr("Enter a detailed comment to create a note", new Object[0]), ImageProvider.get("dialogs/notes", "note_new"));
        if (dialog.getValue() != 1) {
            Logging.debug("User aborted note creation");
            return;
        }
        String input = dialog.getInputText();
        if (input != null && !input.isEmpty()) {
            LatLon latlon = map.mapView.getLatLon(e.getPoint().x, e.getPoint().y);
            this.noteData.createNote(latlon, input);
        } else {
            new Notification(I18n.tr("You must enter a comment to create a new note", new Object[0])).setIcon(2).show();
        }
    }

    @Override
    public void doKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            MapFrame map = MainApplication.getMap();
            map.selectMapMode(map.mapModeSelect);
        }
    }

    @Override
    public void doKeyReleased(KeyEvent e) {
    }

    @Override
    protected boolean listenToLayerChange() {
        return false;
    }

    @Override
    protected boolean listenToSelectionChange() {
        return false;
    }
}

