/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jcs3.auxiliary.AbstractAuxiliaryCache;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCache;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheNoWait;
import org.apache.commons.jcs3.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.commons.jcs3.engine.CacheStatus;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.ICacheType;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs3.engine.stats.StatElement;
import org.apache.commons.jcs3.engine.stats.Stats;
import org.apache.commons.jcs3.engine.stats.behavior.IStats;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

public abstract class AbstractRemoteCacheNoWaitFacade<K, V>
extends AbstractAuxiliaryCache<K, V> {
    private static final Log log = LogManager.getLog(AbstractRemoteCacheNoWaitFacade.class);
    protected List<RemoteCacheNoWait<K, V>> noWaits;
    private final IRemoteCacheAttributes remoteCacheAttributes;

    public AbstractRemoteCacheNoWaitFacade(List<RemoteCacheNoWait<K, V>> noWaits, IRemoteCacheAttributes rca, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        log.debug("CONSTRUCTING NO WAIT FACADE");
        this.remoteCacheAttributes = rca;
        this.setCacheEventLogger(cacheEventLogger);
        this.setElementSerializer(elementSerializer);
        this.noWaits = new ArrayList<RemoteCacheNoWait<K, V>>(noWaits);
        for (RemoteCacheNoWait<K, V> nw : this.noWaits) {
            ((RemoteCache)nw.getRemoteCache()).setFacade(this);
        }
    }

    @Override
    public void update(ICacheElement<K, V> ce) throws IOException {
        log.debug("updating through cache facade, noWaits.length = {0}", () -> this.noWaits.size());
        for (RemoteCacheNoWait<K, V> nw : this.noWaits) {
            try {
                nw.update(ce);
            }
            catch (IOException ex) {
                String message = "Problem updating no wait. Will initiate failover if the noWait is in error.";
                log.error(message, ex);
                if (this.getCacheEventLogger() != null) {
                    this.getCacheEventLogger().logError("RemoteCacheNoWaitFacade", "update", message + ":" + ex.getMessage() + " REGION: " + ce.getCacheName() + " ELEMENT: " + ce);
                }
                this.failover(nw);
            }
        }
    }

    @Override
    public ICacheElement<K, V> get(K key) {
        for (RemoteCacheNoWait<K, V> nw : this.noWaits) {
            try {
                ICacheElement<K, V> obj = nw.get(key);
                if (obj == null) continue;
                return obj;
            }
            catch (IOException ex) {
                log.debug("Failed to get.");
                return null;
            }
        }
        return null;
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMatching(String pattern) throws IOException {
        for (RemoteCacheNoWait<K, V> nw : this.noWaits) {
            try {
                return nw.getMatching(pattern);
            }
            catch (IOException ex) {
                log.debug("Failed to getMatching.");
            }
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMultiple(Set<K> keys) {
        if (keys != null && !keys.isEmpty()) {
            for (RemoteCacheNoWait<K, V> nw : this.noWaits) {
                try {
                    return nw.getMultiple(keys);
                }
                catch (IOException ex) {
                    log.debug("Failed to get.");
                }
            }
        }
        return Collections.emptyMap();
    }

    @Override
    public Set<K> getKeySet() throws IOException {
        HashSet<K> allKeys = new HashSet<K>();
        for (RemoteCacheNoWait<K, V> nw : this.noWaits) {
            Set<K> keys;
            if (nw == null || (keys = nw.getKeySet()) == null) continue;
            allKeys.addAll(keys);
        }
        return allKeys;
    }

    @Override
    public boolean remove(K key) {
        try {
            for (RemoteCacheNoWait<K, V> nw : this.noWaits) {
                nw.remove(key);
            }
        }
        catch (IOException ex) {
            log.error(ex);
        }
        return false;
    }

    @Override
    public void removeAll() {
        try {
            for (RemoteCacheNoWait<K, V> nw : this.noWaits) {
                nw.removeAll();
            }
        }
        catch (IOException ex) {
            log.error(ex);
        }
    }

    @Override
    public void dispose() {
        for (RemoteCacheNoWait<K, V> nw : this.noWaits) {
            nw.dispose();
        }
    }

    @Override
    public int getSize() {
        return 0;
    }

    @Override
    public ICacheType.CacheType getCacheType() {
        return ICacheType.CacheType.REMOTE_CACHE;
    }

    @Override
    public String getCacheName() {
        return this.remoteCacheAttributes.getCacheName();
    }

    @Override
    public CacheStatus getStatus() {
        for (RemoteCacheNoWait<K, V> nw : this.noWaits) {
            if (nw.getStatus() != CacheStatus.ALIVE) continue;
            return CacheStatus.ALIVE;
        }
        return CacheStatus.DISPOSED;
    }

    public String toString() {
        return "RemoteCacheNoWaitFacade: " + this.remoteCacheAttributes.getCacheName() + ", rca = " + this.remoteCacheAttributes;
    }

    protected abstract void failover(RemoteCacheNoWait<K, V> var1);

    public RemoteCacheNoWait<K, V> getPrimaryServer() {
        return this.noWaits.get(0);
    }

    public void restorePrimaryServer(RemoteCacheNoWait<K, V> rcnw) {
        this.noWaits.clear();
        this.noWaits.add(rcnw);
    }

    @Override
    public IRemoteCacheAttributes getAuxiliaryCacheAttributes() {
        return this.remoteCacheAttributes;
    }

    @Override
    public String getStats() {
        return this.getStatistics().toString();
    }

    @Override
    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Remote Cache No Wait Facade");
        ArrayList elems = new ArrayList();
        if (this.noWaits != null) {
            elems.add(new StatElement<Integer>("Number of No Waits", this.noWaits.size()));
            for (RemoteCacheNoWait<K, V> rcnw : this.noWaits) {
                IStats sStats = rcnw.getStatistics();
                elems.addAll(sStats.getStatElements());
            }
        }
        stats.setStatElements(elems);
        return stats;
    }

    @Override
    public String getEventLoggingExtraInfo() {
        return "Remote Cache No Wait Facade";
    }
}

