/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;

public class MemoryTileCache
implements TileCache {
    protected static final Logger log = Logger.getLogger(MemoryTileCache.class.getName());
    protected int cacheSize;
    protected final Map<String, CacheEntry> hash;
    protected final CacheLinkedListElement lruTiles;

    public MemoryTileCache() {
        this(200);
    }

    public MemoryTileCache(int cacheSize) {
        this.cacheSize = cacheSize;
        this.hash = new HashMap<String, CacheEntry>(cacheSize);
        this.lruTiles = new CacheLinkedListElement();
    }

    @Override
    public synchronized void addTile(Tile tile) {
        CacheEntry entry = this.createCacheEntry(tile);
        if (this.hash.put(tile.getKey(), entry) == null) {
            this.lruTiles.addFirst(entry);
            if (this.hash.size() > this.cacheSize || this.lruTiles.getElementCount() > this.cacheSize) {
                this.removeOldEntries();
            }
        }
    }

    @Override
    public synchronized Tile getTile(TileSource source, int x, int y, int z) {
        CacheEntry entry = this.hash.get(Tile.getTileKey(source, x, y, z));
        if (entry == null) {
            return null;
        }
        this.lruTiles.moveElementToFirstPos(entry);
        return entry.tile;
    }

    protected synchronized void removeOldEntries() {
        try {
            while (this.lruTiles.getElementCount() > this.cacheSize) {
                this.removeEntry(this.lruTiles.getLastElement());
            }
        }
        catch (NullPointerException e) {
            log.warning(e.getMessage());
        }
    }

    protected synchronized void removeEntry(CacheEntry entry) {
        this.hash.remove(entry.tile.getKey());
        this.lruTiles.removeEntry(entry);
    }

    protected CacheEntry createCacheEntry(Tile tile) {
        return new CacheEntry(tile);
    }

    @Override
    public synchronized void clear() {
        this.hash.clear();
        this.lruTiles.clear();
    }

    @Override
    public synchronized int getTileCount() {
        return this.hash.size();
    }

    @Override
    public synchronized int getCacheSize() {
        return this.cacheSize;
    }

    public synchronized void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
        if (this.hash.size() > cacheSize) {
            this.removeOldEntries();
        }
    }

    protected static class CacheLinkedListElement {
        protected CacheEntry firstElement;
        protected CacheEntry lastElement;
        protected int elementCount;

        public CacheLinkedListElement() {
            this.clear();
        }

        public void clear() {
            this.elementCount = 0;
            this.firstElement = null;
            this.lastElement = null;
        }

        public void addFirst(CacheEntry element) {
            if (element == null) {
                return;
            }
            if (this.elementCount == 0) {
                this.firstElement = element;
                this.lastElement = element;
                element.prev = null;
                element.next = null;
            } else {
                element.next = this.firstElement;
                this.firstElement.prev = element;
                element.prev = null;
                this.firstElement = element;
            }
            ++this.elementCount;
        }

        public void removeEntry(CacheEntry element) {
            if (element == null) {
                return;
            }
            if (element.next != null) {
                element.next.prev = element.prev;
            }
            if (element.prev != null) {
                element.prev.next = element.next;
            }
            if (element == this.firstElement) {
                this.firstElement = element.next;
            }
            if (element == this.lastElement) {
                this.lastElement = element.prev;
            }
            element.next = null;
            element.prev = null;
            --this.elementCount;
        }

        public void moveElementToFirstPos(CacheEntry entry) {
            if (this.firstElement == entry) {
                return;
            }
            this.removeEntry(entry);
            this.addFirst(entry);
        }

        public int getElementCount() {
            return this.elementCount;
        }

        public CacheEntry getLastElement() {
            return this.lastElement;
        }

        public CacheEntry getFirstElement() {
            return this.firstElement;
        }
    }

    protected static class CacheEntry {
        private final Tile tile;
        private CacheEntry next;
        private CacheEntry prev;

        protected CacheEntry(Tile tile) {
            this.tile = tile;
        }

        public String toString() {
            return this.tile.toString();
        }
    }
}

