/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class OsmApiException
extends OsmTransferException {
    private int responseCode;
    private String contentType;
    private String errorHeader;
    private String errorBody;
    private String accessedUrl;
    private String login;

    public OsmApiException(int responseCode, String errorHeader, String errorBody, String accessedUrl, String login, String contentType) {
        this.responseCode = responseCode;
        this.errorHeader = errorHeader;
        this.errorBody = Utils.strip(errorBody);
        this.accessedUrl = accessedUrl;
        this.login = login;
        this.contentType = contentType;
        this.checkHtmlBody();
    }

    public OsmApiException(int responseCode, String errorHeader, String errorBody, String accessedUrl, String login) {
        this(responseCode, errorHeader, errorBody, accessedUrl, login, null);
    }

    public OsmApiException(int responseCode, String errorHeader, String errorBody, String accessedUrl) {
        this(responseCode, errorHeader, errorBody, accessedUrl, null);
    }

    public OsmApiException(int responseCode, String errorHeader, String errorBody) {
        this(responseCode, errorHeader, errorBody, null);
    }

    public OsmApiException(String message) {
        super(message);
    }

    public OsmApiException(Throwable cause) {
        super(cause);
    }

    public OsmApiException(String message, Throwable cause) {
        super(message, cause);
    }

    private void checkHtmlBody() {
        if (this.errorBody != null && this.errorBody.matches("^<.*>.*<.*>$")) {
            this.setContentType("text/html");
            if (!this.errorBody.contains("<html>")) {
                this.errorBody = "<html>" + this.errorBody + "</html>";
            }
        }
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public String getErrorHeader() {
        return this.errorHeader;
    }

    public void setErrorHeader(String errorHeader) {
        this.errorHeader = errorHeader;
    }

    public String getErrorBody() {
        return this.errorBody;
    }

    public void setErrorBody(String errorBody) {
        this.errorBody = errorBody;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("ResponseCode=").append(this.responseCode);
        String eh = "";
        try {
            if (this.errorHeader != null) {
                eh = I18n.tr(this.errorHeader.trim(), new Object[0]);
            }
            if (!eh.isEmpty()) {
                sb.append(", Error Header=<").append(eh).append('>');
            }
        }
        catch (IllegalArgumentException e) {
            Logging.trace(e);
        }
        try {
            String eb;
            String string = eb = this.errorBody != null ? I18n.tr(this.errorBody.trim(), new Object[0]) : "";
            if (!eb.isEmpty() && !eb.equals(eh)) {
                sb.append(", Error Body=<").append(eb).append('>');
            }
        }
        catch (IllegalArgumentException e) {
            Logging.trace(e);
        }
        return sb.toString();
    }

    public String getDisplayMessage() {
        StringBuilder sb = new StringBuilder();
        String header = Utils.strip(this.errorHeader);
        String body = Utils.strip(this.errorBody);
        if (Utils.isEmpty(header) && Utils.isEmpty(body)) {
            sb.append(I18n.tr("The server replied an error with code {0}.", this.responseCode));
        } else {
            if (!Utils.isEmpty(header)) {
                sb.append(I18n.tr(header, new Object[0]));
            }
            if (!Utils.isEmpty(body) && !body.equals(header)) {
                if (sb.length() > 0) {
                    sb.append(". ");
                }
                sb.append(I18n.tr(body, new Object[0]));
            }
            sb.append(' ').append(I18n.tr("(Code={0})", this.responseCode));
        }
        return sb.toString();
    }

    public void setAccessedUrl(String url) {
        this.accessedUrl = url;
    }

    public String getAccessedUrl() {
        return this.accessedUrl;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getLogin() {
        return this.login;
    }

    public final void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public final String getContentType() {
        return this.contentType;
    }

    public final boolean isHtml() {
        return "text/html".equals(this.contentType);
    }
}

