/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.styleelement;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.util.Objects;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.StyleKeys;
import org.openstreetmap.josm.gui.mappaint.styleelement.LabelCompositionStrategy;
import org.openstreetmap.josm.gui.mappaint.styleelement.NodeElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.StyleElement;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.RotationAngle;

public class TextLabel
implements StyleKeys {
    public static final LabelCompositionStrategy AUTO_LABEL_COMPOSITION_STRATEGY = new LabelCompositionStrategy.DeriveLabelFromNameTagsCompositionStrategy();
    public LabelCompositionStrategy labelCompositionStrategy;
    public Font font;
    public RotationAngle rotationAngle;
    public Color color;
    public Float haloRadius;
    public Color haloColor;

    protected TextLabel(LabelCompositionStrategy strategy, Font font, RotationAngle rotationAngle, Color color, Float haloRadius, Color haloColor) {
        this.labelCompositionStrategy = strategy;
        this.font = Objects.requireNonNull(font, "font");
        this.rotationAngle = Objects.requireNonNull(rotationAngle, "rotationAngle");
        this.color = Objects.requireNonNull(color, "color");
        this.haloRadius = haloRadius;
        this.haloColor = haloColor;
    }

    public TextLabel(TextLabel other) {
        this.labelCompositionStrategy = other.labelCompositionStrategy;
        this.font = other.font;
        this.rotationAngle = other.rotationAngle;
        this.color = other.color;
        this.haloColor = other.haloColor;
        this.haloRadius = other.haloRadius;
    }

    protected static LabelCompositionStrategy buildLabelCompositionStrategy(Cascade c, boolean defaultAnnotate) {
        MapPaintStyles.TagKeyReference tkr = c.get("text", null, MapPaintStyles.TagKeyReference.class, true);
        if (tkr != null) {
            return new LabelCompositionStrategy.TagLookupCompositionStrategy(tkr.key);
        }
        Keyword keyword = c.get("text", null, Keyword.class, true);
        if (Keyword.AUTO.equals(keyword)) {
            return AUTO_LABEL_COMPOSITION_STRATEGY;
        }
        String text = c.get("text", null, String.class, true);
        if (text != null) {
            return new LabelCompositionStrategy.StaticLabelCompositionStrategy(text);
        }
        return defaultAnnotate ? AUTO_LABEL_COMPOSITION_STRATEGY : null;
    }

    public static TextLabel create(Environment env, Color defaultTextColor, boolean defaultAnnotate) {
        CheckParameterUtil.ensureParameterNotNull(defaultTextColor);
        Cascade c = env.getCascade();
        LabelCompositionStrategy strategy = TextLabel.buildLabelCompositionStrategy(c, defaultAnnotate);
        if (strategy == null) {
            return null;
        }
        String s = strategy.compose(env.osm);
        if (s == null) {
            return null;
        }
        Font font = StyleElement.getFont(c, s);
        RotationAngle rotationAngle = NodeElement.createTextRotationAngle(env);
        Color color = c.get("text-color", defaultTextColor, Color.class);
        float alpha = c.get("text-opacity", Float.valueOf(1.0f), Float.class).floatValue();
        color = ColorHelper.alphaMultiply(color, alpha);
        Float haloRadius = c.get("text-halo-radius", null, Float.class);
        if (haloRadius != null && haloRadius.floatValue() <= 0.0f) {
            haloRadius = null;
        }
        Color haloColor = null;
        if (haloRadius != null) {
            haloColor = c.get("text-halo-color", ColorHelper.complement(color), Color.class);
            float haloAlphaFactor = c.get("text-halo-opacity", Float.valueOf(1.0f), Float.class).floatValue();
            haloColor = ColorHelper.alphaMultiply(haloColor, haloAlphaFactor);
        }
        return new TextLabel(strategy, font, rotationAngle, color, haloRadius, haloColor);
    }

    public static Point2D getTextOffset(Cascade c) {
        float xOffset = 0.0f;
        float yOffset = 0.0f;
        float[] offset = c.get("text-offset", null, float[].class);
        if (offset != null) {
            if (offset.length == 1) {
                yOffset = offset[0];
            } else if (offset.length >= 2) {
                xOffset = offset[0];
                yOffset = offset[1];
            }
        }
        xOffset = c.get("text-offset-x", Float.valueOf(xOffset), Float.class).floatValue();
        yOffset = c.get("text-offset-y", Float.valueOf(yOffset), Float.class).floatValue();
        return new Point2D.Double(xOffset, yOffset);
    }

    public String getString(IPrimitive osm) {
        if (this.labelCompositionStrategy == null) {
            return null;
        }
        return this.labelCompositionStrategy.compose(osm);
    }

    public String toString() {
        return "TextLabel{" + this.toStringImpl() + "}";
    }

    protected String toStringImpl() {
        StringBuilder sb = new StringBuilder(96);
        sb.append("labelCompositionStrategy=").append(this.labelCompositionStrategy).append(" font=").append(this.font).append(" rotationAngle=").append(this.rotationAngle).append(" color=").append(ColorHelper.color2html(this.color));
        if (this.haloRadius != null) {
            sb.append(" haloRadius=").append(this.haloRadius).append(" haloColor=").append(this.haloColor);
        }
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(this.labelCompositionStrategy, this.font, this.rotationAngle, this.color, this.haloRadius, this.haloColor);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TextLabel textLabel = (TextLabel)obj;
        return Objects.equals(this.labelCompositionStrategy, textLabel.labelCompositionStrategy) && Objects.equals(this.font, textLabel.font) && Objects.equals(this.rotationAngle, textLabel.rotationAngle) && Objects.equals(this.color, textLabel.color) && Objects.equals(this.haloRadius, textLabel.haloRadius) && Objects.equals(this.haloColor, textLabel.haloColor);
    }
}

