/**********************************************************************
 *
 *    FILE:            ColorMask.cpp
 *
 *    DESCRIPTION:    Read/Write osg::ColorMask in binary format to disk.
 *
 *    CREATED BY:        Auto generated by iveGenerator
 *                    and later modified by Rune Schmidt Jensen.
 *
 *    HISTORY:        Created 27.3.2003
 *
 *    Copyright 2003 VR-C
 **********************************************************************/

#include "Exception.h"
#include "ColorMask.h"
#include "Object.h"

using namespace ive;

void ColorMask::write(DataOutputStream* out){
    // Write ColorMask's identification.
    out->writeInt(IVECOLORMASK);
    // If the osg class is inherited by any other class we should also write this to file.
    osg::Object*  obj = dynamic_cast<osg::Object*>(this);
    if(obj){
        ((ive::Object*)(obj))->write(out);
    }
    else
        out_THROW_EXCEPTION("ColorMask::write(): Could not cast this osg::ColorMask to an osg::Object.");

    // Write ColorMask's properties.
    out->writeBool(getRedMask());
    out->writeBool(getGreenMask());
    out->writeBool(getBlueMask());
    out->writeBool(getAlphaMask());
}

void ColorMask::read(DataInputStream* in){
    // Peek on ColorMask's identification.
    int id = in->peekInt();
    if(id == IVECOLORMASK){
        // Read ColorMask's identification.
        id = in->readInt();
        // If the osg class is inherited by any other class we should also read this from file.
        osg::Object*  obj = dynamic_cast<osg::Object*>(this);
        if(obj){
            ((ive::Object*)(obj))->read(in);
        }
        else
            in_THROW_EXCEPTION("ColorMask::read(): Could not cast this osg::ColorMask to an osg::Object.");

        // Read ColorMask's properties
        setRedMask(in->readBool());
        setGreenMask(in->readBool());
        setBlueMask(in->readBool());
        setAlphaMask(in->readBool());
    }
    else{
        in_THROW_EXCEPTION("ColorMask::read(): Expected ColorMask identification.");
    }
}
