/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.util;

import java.util.StringTokenizer;

public class JavaUtils {
    private static boolean versionInitialised = false;
    private static int majorVersion = 1;
    private static int minorVersion = 0;
    private static int isJRE15 = -1;
    private static int isJRE16 = -1;

    public static boolean isJRE1_5OrAbove() {
        if (isJRE15 == -1) {
            try {
                Class.forName("java.util.Queue");
                isJRE15 = 1;
            }
            catch (Exception e) {
                isJRE15 = 0;
            }
        }
        return isJRE15 == 1;
    }

    public static boolean isJRE1_6OrAbove() {
        if (isJRE16 == -1) {
            try {
                Class.forName("java.util.Deque");
                isJRE16 = 1;
            }
            catch (Exception e) {
                isJRE16 = 0;
            }
        }
        return isJRE16 == 1;
    }

    public static int getJREMajorVersion() {
        if (!versionInitialised) {
            JavaUtils.initialiseJREVersion();
        }
        return majorVersion;
    }

    public static int getJREMinorVersion() {
        if (!versionInitialised) {
            JavaUtils.initialiseJREVersion();
        }
        return minorVersion;
    }

    private static void initialiseJREVersion() {
        String version = System.getProperty("java.version");
        StringTokenizer tokeniser = new StringTokenizer(version, ".");
        String token = tokeniser.nextToken();
        try {
            Integer ver = new Integer(token);
            majorVersion = ver;
            token = tokeniser.nextToken();
            ver = new Integer(token);
            minorVersion = ver;
        }
        catch (Exception exception) {
            // empty catch block
        }
        versionInitialised = true;
    }

    public static boolean isGreaterEqualsThan(String version) {
        boolean greaterEquals = false;
        StringTokenizer tokeniser = new StringTokenizer(version, ".");
        String token = tokeniser.nextToken();
        try {
            Integer ver = new Integer(token);
            int majorVersion = ver;
            token = tokeniser.nextToken();
            ver = new Integer(token);
            int minorVersion = ver;
            if (JavaUtils.getJREMajorVersion() >= majorVersion && JavaUtils.getJREMinorVersion() >= minorVersion) {
                greaterEquals = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return greaterEquals;
    }

    public static boolean isEqualsThan(String version) {
        boolean equals = false;
        StringTokenizer tokeniser = new StringTokenizer(version, ".");
        String token = tokeniser.nextToken();
        try {
            Integer ver = new Integer(token);
            int majorVersion = ver;
            token = tokeniser.nextToken();
            ver = new Integer(token);
            int minorVersion = ver;
            if (JavaUtils.getJREMajorVersion() == majorVersion && JavaUtils.getJREMinorVersion() == minorVersion) {
                equals = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return equals;
    }
}

