/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.testing;

import com.google.appengine.api.rdbms.dev.LocalRdbmsService;
import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.appengine.tools.development.testing.LocalServiceTestConfig;
import com.google.appengine.tools.development.testing.LocalServiceTestHelper;
import com.google.cloud.sql.jdbc.internal.SqlClientFactory;
import java.util.Map;
import org.hsqldb.jdbcDriver;

public class LocalRdbmsServiceTestConfig
implements LocalServiceTestConfig {
    private String driverClass = jdbcDriver.class.getName();
    private String driverUrl = "jdbc:hsqldb:mem:%s";
    private LocalRdbmsService.ServerType serverType = LocalRdbmsService.ServerType.LOCAL;
    private String extraDriverProperties;
    private Class<? extends SqlClientFactory> remoteClientFactory;
    private String database;
    private String user;
    private String password;

    @Override
    public void setUp() {
        ApiProxyLocal proxy = LocalServiceTestHelper.getApiProxyLocal();
        proxy.setProperty("rdbms.driver", this.driverClass);
        proxy.setProperty("rdbms.url", this.driverUrl);
        proxy.setProperty("rdbms.server", this.serverType.flagValue());
        proxy.setProperty("rdbms.extra.properties", this.extraDriverProperties);
        if (this.remoteClientFactory != null) {
            proxy.setProperty("rdbms.hosted.client.factory", this.remoteClientFactory.getName());
        }
        if (this.database != null) {
            proxy.setProperty("rdbms.database", this.database);
        }
        if (this.user != null) {
            proxy.setProperty("rdbms.user", this.user);
        }
        if (this.password != null) {
            proxy.setProperty("rdbms.password", this.password);
        }
    }

    @Override
    public void tearDown() {
    }

    public static LocalRdbmsService getLocalRdbmsService() {
        return (LocalRdbmsService)LocalServiceTestHelper.getLocalService("rdbms");
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public LocalRdbmsServiceTestConfig setDriverClass(String driverClass) {
        this.driverClass = driverClass;
        try {
            Class.forName(driverClass);
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
        return this;
    }

    public String getJdbcConnectionStringFormat() {
        return this.driverUrl;
    }

    public LocalRdbmsServiceTestConfig setJdbcConnectionStringFormat(String jdbcConnectionStringFormat) {
        this.driverUrl = jdbcConnectionStringFormat;
        return this;
    }

    public LocalRdbmsServiceTestConfig setServerType(LocalRdbmsService.ServerType serverType) {
        if (serverType == null) {
            throw new NullPointerException("serverType can not be null");
        }
        this.serverType = serverType;
        return this;
    }

    public LocalRdbmsServiceTestConfig setExtraDriverProperties(Map<String, String> map) {
        this.extraDriverProperties = Joiner.on(',').withKeyValueSeparator("=").join(map);
        return this;
    }

    public LocalRdbmsServiceTestConfig setDatabase(String database) {
        this.database = database;
        return this;
    }

    public LocalRdbmsServiceTestConfig setUser(String user) {
        this.user = user;
        return this;
    }

    public LocalRdbmsServiceTestConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    public LocalRdbmsServiceTestConfig setRemoteClientFactory(Class<? extends SqlClientFactory> remoteClientFactory) {
        this.remoteClientFactory = remoteClientFactory;
        return this;
    }
}

