/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine.jdo;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jdo.JDOFatalUserException;
import javax.jdo.PersistenceManagerFactory;
import org.datanucleus.jdo.JDOPersistenceManager;
import org.datanucleus.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.store.appengine.ConcurrentHashMapHelper;
import org.datanucleus.store.appengine.Utils;
import org.datanucleus.store.appengine.jdo.DatastoreJDOPersistenceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatastoreJDOPersistenceManagerFactory
extends JDOPersistenceManagerFactory {
    private static final ConcurrentHashMap<String, AtomicInteger> NUM_INSTANCES_PER_PERSISTENCE_UNIT = new ConcurrentHashMap();
    public static final String DISABLE_DUPLICATE_PMF_EXCEPTION_PROPERTY = "appengine.orm.disable.duplicate.pmf.exception";
    private static final String DUPLICATE_PMF_ERROR_FORMAT = "Application code attempted to create a PersistenceManagerFactory named %s, but one with this name already exists!  Instances of PersistenceManagerFactory are extremely slow to create and it is usually not necessary to create one with a given name more than once.  Instead, create a singleton and share it throughout your code.  If you really do need to create a duplicate PersistenceManagerFactory (such as for a unittest suite), set the appengine.orm.disable.duplicate.pmf.exception system property to avoid this error.";

    public DatastoreJDOPersistenceManagerFactory(Map props) {
        super(props);
    }

    protected JDOPersistenceManager newPM(JDOPersistenceManagerFactory jdoPersistenceManagerFactory, String userName, String password) {
        return new DatastoreJDOPersistenceManager(jdoPersistenceManagerFactory, userName, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized PersistenceManagerFactory getPersistenceManagerFactory(Map overridingProps) {
        HashMap<String, String> overridingMap;
        if (overridingProps instanceof Properties) {
            overridingMap = new HashMap<String, String>();
            Enumeration<?> e = ((Properties)((Object)overridingProps)).propertyNames();
            while (e.hasMoreElements()) {
                String param = (String)e.nextElement();
                overridingMap.put(param, ((Properties)((Object)overridingProps)).getProperty(param));
            }
        } else {
            overridingMap = overridingProps;
        }
        if (overridingMap == null) {
            overridingMap = Utils.newHashMap();
        }
        if (!overridingMap.containsKey("datanucleus.identifier.case")) {
            overridingMap.put("datanucleus.identifier.case", "PreserveCase");
        }
        DatastoreJDOPersistenceManagerFactory pmf = new DatastoreJDOPersistenceManagerFactory(overridingMap);
        pmf.freezeConfiguration();
        if (DatastoreJDOPersistenceManagerFactory.alreadyAllocated(pmf.getName())) {
            try {
                pmf.close();
            }
            catch (Throwable throwable) {
                throw new JDOFatalUserException(String.format(DUPLICATE_PMF_ERROR_FORMAT, pmf.getName()));
            }
            throw new JDOFatalUserException(String.format(DUPLICATE_PMF_ERROR_FORMAT, pmf.getName()));
        }
        return pmf;
    }

    private static boolean alreadyAllocated(String name) {
        if (name == null) {
            return false;
        }
        AtomicInteger count = ConcurrentHashMapHelper.getCounter(NUM_INSTANCES_PER_PERSISTENCE_UNIT, name);
        return count.incrementAndGet() > 1 && !System.getProperties().containsKey(DISABLE_DUPLICATE_PMF_EXCEPTION_PROPERTY);
    }

    static ConcurrentHashMap<String, AtomicInteger> getNumInstancesPerPersistenceUnit() {
        return NUM_INSTANCES_PER_PERSISTENCE_UNIT;
    }
}

