/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flags;

import com.google.appengine.repackaged.com.google.common.flags.DocLevel;

class FlagDescription
implements Comparable<FlagDescription> {
    private final String simpleFieldName;
    private final String shortFlagName;
    private final String containerClassName;
    private final String type;
    private final String doc;
    private final DocLevel docLevel;
    private final String altName;

    private FlagDescription(String shortFlagName, String containerClassName, String simpleFieldName, String type, String doc, DocLevel docLevel, String altName) {
        if (containerClassName == null) {
            throw new NullPointerException();
        }
        if (type == null) {
            throw new NullPointerException();
        }
        if (doc == null) {
            throw new NullPointerException();
        }
        if (docLevel == null) {
            throw new NullPointerException();
        }
        this.shortFlagName = FlagDescription.emptyStringToNull(shortFlagName);
        this.containerClassName = containerClassName;
        this.simpleFieldName = simpleFieldName;
        this.type = type;
        this.doc = doc;
        this.docLevel = docLevel;
        this.altName = FlagDescription.emptyStringToNull(altName);
        if (!this.isField() && !this.isShortFlagNameSpecified()) {
            throw new NullPointerException();
        }
        FlagDescription.checkNotReserved(this.getShortFlagName());
        FlagDescription.checkNotReserved(this.getAltName());
    }

    private static void checkNotReserved(String s) {
        if (s != null && (s.equals("help") || s.equals("helpxml") || s.equals("flagfile") || s.equals("flagresource"))) {
            throw new IllegalArgumentException("The " + s + " flag is built-in and may not be registered");
        }
    }

    static Builder createFlagFromField(String fullyQualifiedFieldName) {
        return new Builder(FlagDescription.parseContainerClassName(fullyQualifiedFieldName), FlagDescription.parseSimpleFieldName(fullyQualifiedFieldName));
    }

    static Builder createManuallyRegisteredFlag(String shortFlagName, String containerClassName) {
        return new Builder(containerClassName, null).shortFlagName(FlagDescription.stripFlagPrefix(shortFlagName));
    }

    String getLongFlagName() {
        return this.getContainerClassName() + "." + this.getShortFlagName();
    }

    String getFullyQualifiedFieldName() {
        return this.getContainerClassName() + "." + this.getSimpleFieldName();
    }

    String getSimpleFieldName() {
        if (!this.isField()) {
            throw new UnsupportedOperationException("Flag " + this.getLongFlagName() + " is not associated with a field");
        }
        return this.simpleFieldName;
    }

    boolean isField() {
        return this.simpleFieldName != null;
    }

    String getShortFlagName() {
        return this.isShortFlagNameSpecified() ? this.shortFlagName : FlagDescription.stripFlagPrefix(this.getSimpleFieldName());
    }

    boolean isShortFlagNameSpecified() {
        return this.shortFlagName != null;
    }

    String getContainerClassName() {
        return this.containerClassName;
    }

    String getType() {
        return this.type;
    }

    String getDoc() {
        return this.doc;
    }

    DocLevel getDocLevel() {
        return this.docLevel;
    }

    String getAltName() {
        return this.altName;
    }

    boolean isPositiveFormOfName(String name) {
        if (name == null) {
            return false;
        }
        return name.equals(this.getShortFlagName()) || name.equals(this.getAltName()) || name.equals(this.getLongFlagName()) || this.isField() && name.equals(this.getFullyQualifiedFieldName());
    }

    public String toString() {
        return this.getLongFlagName();
    }

    public boolean equals(Object other) {
        if (!(other instanceof FlagDescription)) {
            return false;
        }
        FlagDescription o = (FlagDescription)other;
        return o == this || o.getShortFlagName().equals(this.getShortFlagName()) && o.containerClassName.equals(this.containerClassName) && FlagDescription.nullSafeEquals(o.simpleFieldName, this.simpleFieldName) && o.type.equals(this.type) && o.doc.equals(this.doc) && o.docLevel.equals((Object)this.docLevel) && FlagDescription.nullSafeEquals(o.altName, this.altName);
    }

    public int hashCode() {
        return this.getLongFlagName().hashCode();
    }

    @Override
    public int compareTo(FlagDescription o) {
        return this.getLongFlagName().compareTo(o.getLongFlagName());
    }

    private static String stripFlagPrefix(String flagName) {
        return flagName.startsWith("FLAG_") ? flagName.substring(5) : flagName;
    }

    private static String parseSimpleFieldName(String fullyQualifiedName) {
        return fullyQualifiedName.substring(FlagDescription.findLastDotIndex(fullyQualifiedName) + 1);
    }

    private static String parseContainerClassName(String fullyQualifiedName) {
        return fullyQualifiedName.substring(0, FlagDescription.findLastDotIndex(fullyQualifiedName));
    }

    private static int findLastDotIndex(String name) {
        int idx = name.lastIndexOf(".");
        if (idx <= 0) {
            throw new IllegalArgumentException("Package name required in name: " + name);
        }
        return idx;
    }

    private static boolean nullSafeEquals(Object left, Object right) {
        return left == null ? left == right : left.equals(right);
    }

    private static String emptyStringToNull(String string) {
        return string == null || string.isEmpty() ? null : string;
    }

    static class Builder {
        private final String containerClassName;
        private final String simpleFieldName;
        private String shortFlagName;
        private String type;
        private String doc;
        private DocLevel docLevel;
        private String altName;

        private Builder(String containerClassName, String simpleFieldName) {
            this.containerClassName = containerClassName;
            this.simpleFieldName = simpleFieldName;
        }

        Builder shortFlagName(String shortFlagName) {
            this.shortFlagName = shortFlagName;
            return this;
        }

        Builder type(String type) {
            this.type = type;
            return this;
        }

        Builder doc(String doc) {
            this.doc = doc;
            return this;
        }

        Builder altName(String altName) {
            this.altName = altName;
            return this;
        }

        Builder docLevel(DocLevel docLevel) {
            this.docLevel = docLevel;
            return this;
        }

        FlagDescription build() {
            return new FlagDescription(this.shortFlagName, this.containerClassName, this.simpleFieldName, this.type, this.doc, this.docLevel, this.altName);
        }
    }
}

