/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.protocol;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.X;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.primitives.Bytes;
import com.google.appengine.repackaged.com.google.io.protocol.GrowableProtocolSink;
import com.google.appengine.repackaged.com.google.io.protocol.MessageVisitor;
import com.google.appengine.repackaged.com.google.io.protocol.Protocol;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSink;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSource;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSupport;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolType;
import com.google.appengine.repackaged.com.google.io.protocol.RawMessage;
import com.google.appengine.repackaged.com.google.io.protocol.proto.ProtocolDescriptor;
import com.google.appengine.repackaged.com.google.protobuf.CodedOutputStream;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class MessageSet
extends ProtocolMessage<MessageSet> {
    private static final byte TAG_BEGIN_ITEM_GROUP = 11;
    private static final byte TAG_END_ITEM_GROUP = 12;
    private static final byte TAG_TYPE_ID = 16;
    private static final byte TAG_MESSAGE = 26;
    private final Map<Integer, Item> items;
    private static final Logger LOG = Logger.getLogger(MessageSet.class.getName());
    public static final MessageSet IMMUTABLE_DEFAULT_INSTANCE = new MessageSet(ImmutableMap.<Integer, Item>of());
    private static ProtocolType cachedClassProtocolType;
    private static final ConcurrentMap<Object, TypedIdInfo> typedIdHash;
    private static final TypedIdInfo TYPED_ID_ERROR;
    private static boolean allowDuplicates;
    public static final int NO_TYPE_ID = 0;

    @Override
    public MessageSet getDefaultInstanceForType() {
        return IMMUTABLE_DEFAULT_INSTANCE;
    }

    public static MessageSet getDefaultInstance() {
        return IMMUTABLE_DEFAULT_INSTANCE;
    }

    public MessageSet() {
        this.items = Maps.newTreeMap();
    }

    private MessageSet(Map<Integer, Item> items) {
        this.items = items;
    }

    @Nullable
    private byte[] get(int typeId) {
        Item item = this.items.get(typeId);
        if (item == null) {
            return null;
        }
        if (item.isByteArray()) {
            return (byte[])item.asByteArray().clone();
        }
        return item.asParsedMessage().toByteArray();
    }

    public <T extends ProtocolMessage> T get(Class<T> messageClass) {
        int typeId = MessageSet.getTypeId(messageClass);
        if (typeId == 0) {
            throw MessageSet.newNoTypeIdException(messageClass);
        }
        Item item = this.items.get(typeId);
        if (item == null || !item.parseAs(messageClass)) {
            return ProtocolSupport.newInstance(messageClass);
        }
        return (T)((ProtocolMessage)messageClass.cast(item.asProtocol1()));
    }

    public MessageLite get(int typeId, MessageLite prototype) {
        if (typeId == 0) {
            throw new IllegalArgumentException("Bad TypeId");
        }
        Item item = this.items.get(typeId);
        if (item != null && item.parseAs(prototype)) {
            return item.asParsedMessage();
        }
        return prototype.getDefaultInstanceForType();
    }

    public <T extends ProtocolMessage> T mutable(Class<T> messageClass) {
        int typeId = MessageSet.getTypeId(messageClass);
        if (typeId == 0) {
            throw MessageSet.newNoTypeIdException(messageClass);
        }
        Item item = this.items.get(typeId);
        if (item == null || !item.parseAs(messageClass)) {
            item = Item.from(ProtocolSupport.newInstance(messageClass));
            this.items.put(typeId, item);
        }
        return (T)((ProtocolMessage)messageClass.cast(item.asProtocol1()));
    }

    public <T extends ProtocolMessage> MessageSet add(T message) {
        int typeId = MessageSet.getTypeId(MessageSet.findCanonicalProtocolMessageClass(message.getClass()));
        if (typeId == 0) {
            throw MessageSet.newNoTypeIdException(message.getClass());
        }
        this.items.put(typeId, Item.from(message));
        return this;
    }

    public MessageSet add(int typeId, MessageLite message) {
        if (typeId == 0) {
            throw new IllegalArgumentException("Bad TypeId");
        }
        this.items.put(typeId, Item.from(message));
        return this;
    }

    public boolean has(Class<? extends ProtocolMessage> messageClass) {
        int typeId = MessageSet.getTypeId(messageClass);
        if (typeId == 0) {
            return false;
        }
        Item item = this.items.get(typeId);
        return item != null && item.parseAs(messageClass);
    }

    public boolean has(int typeId, MessageLite prototype) {
        if (typeId == 0) {
            throw new IllegalArgumentException("Bad TypeId");
        }
        Item item = this.items.get(typeId);
        return item != null && item.parseAs(prototype);
    }

    public boolean hasUnparsed(Class<? extends ProtocolMessage> messageClass) {
        int typeId = MessageSet.getTypeId(messageClass);
        return typeId != 0 && this.items.containsKey(typeId);
    }

    public boolean hasUnparsed(int typeId) {
        if (typeId == 0) {
            throw new IllegalArgumentException("Bad TypeId");
        }
        return this.items.containsKey(typeId);
    }

    public void remove(Class<? extends ProtocolMessage> messageClass) {
        int typeId = MessageSet.getTypeId(messageClass);
        if (typeId == 0) {
            throw MessageSet.newNoTypeIdException(messageClass);
        }
        this.remove(typeId);
    }

    public void remove(int typeId) {
        this.items.remove(typeId);
    }

    public Set<Integer> getTypeIds() {
        return Collections.unmodifiableSet(this.items.keySet());
    }

    public int numMessages() {
        return this.items.size();
    }

    @Override
    public MessageSet mergeFrom(MessageSet that) {
        X.assertTrue(that != this);
        for (Map.Entry<Integer, Item> entry : that.items.entrySet()) {
            Item item = this.items.get(entry.getKey());
            if (item != null) {
                item.mergeFrom(entry.getValue());
                continue;
            }
            this.items.put(entry.getKey(), entry.getValue().copy());
        }
        return this;
    }

    @Override
    public boolean equals(MessageSet that, boolean ignoreUninterpreted) {
        if (this == that) {
            return true;
        }
        return ((Object)this.items).equals(that.items);
    }

    @Override
    public boolean equalsIgnoreUninterpreted(MessageSet that) {
        return this.equals(that, true);
    }

    @Override
    public boolean equals(MessageSet that) {
        return this.equals(that, false);
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof MessageSet && this.equals((MessageSet)that);
    }

    @Override
    public int hashCode() {
        throw new RuntimeException("Do not use MessageSets as hash table keys.");
    }

    @Override
    public boolean isInitialized() {
        for (Item item : this.items.values()) {
            if (item.isInitialized()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int encodingSize() {
        int size = this.items.size() * 4;
        for (Map.Entry<Integer, Item> entry : this.items.entrySet()) {
            Item item = entry.getValue();
            int typeId = entry.getKey();
            int messageSize = item.encodingSize();
            size += Protocol.stringSize(messageSize) + Protocol.varIntSize(typeId);
        }
        return size;
    }

    @Override
    public int maxEncodingSize() {
        int size = this.items.size() * 14;
        for (Item item : this.items.values()) {
            size += item.maxEncodingSize();
        }
        return size;
    }

    @Override
    public void clear() {
        this.items.clear();
    }

    @Override
    public MessageSet newInstance() {
        return new MessageSet();
    }

    @Override
    public void outputTo(ProtocolSink sink) {
        for (Map.Entry<Integer, Item> entry : this.items.entrySet()) {
            Item item = entry.getValue();
            Integer typeId = entry.getKey();
            sink.putByte((byte)11);
            sink.putByte((byte)16);
            sink.putVarInt(typeId);
            sink.putByte((byte)26);
            sink.putVarInt(item.encodingSize());
            item.output(sink);
            sink.putByte((byte)12);
        }
    }

    @Override
    public boolean merge(ProtocolSource source) {
        block4: while (source.remaining() > 0) {
            int tag = source.getVarInt();
            switch (tag) {
                case 0: {
                    return false;
                }
                case 11: {
                    Item item = new Item();
                    int typeId = Item.decode(source, item);
                    if (typeId == 0) {
                        return false;
                    }
                    Item oldItem = this.items.get(typeId);
                    if (oldItem == null) {
                        this.items.put(typeId, item);
                        continue block4;
                    }
                    oldItem.mergeFrom(item);
                    continue block4;
                }
            }
            source.skipData(tag);
        }
        return true;
    }

    @Override
    public ProtocolType getProtocolType() {
        return MessageSet.getClassProtocolType();
    }

    private static synchronized ProtocolType getClassProtocolType() {
        if (cachedClassProtocolType == null) {
            String name = MessageSet.class.getName();
            String fileName = "java/" + name.replace('.', '/') + ".java";
            final ProtocolDescriptor descriptor = new ProtocolDescriptor().setName(name).setProtoName("MessageSet").setFilename(fileName);
            cachedClassProtocolType = new ProtocolType(MessageSet.class, null, new ProtocolType.FieldType[0]){

                @Override
                protected void visitInternal(ProtocolMessage message, ProtocolType.Visitor visitor, Iterable<ProtocolType.FieldType> fields) {
                    ((MessageSet)message).visit(visitor);
                }

                @Override
                protected void visitInternal(ProtocolMessage message, MessageVisitor visitor, Iterable<ProtocolType.FieldType> fields) {
                    ((MessageSet)message).visit(visitor);
                }

                @Override
                public ProtocolDescriptor getProtocolDescriptor() {
                    return descriptor;
                }
            };
        }
        return cachedClassProtocolType;
    }

    private void visit(ProtocolType.Visitor visitor) {
        for (Map.Entry<Integer, Item> entry : this.items.entrySet()) {
            FieldType fieldType;
            Class<? extends ProtocolMessage> clazz;
            int typeId = entry.getKey();
            Item item = entry.getValue();
            if (!item.isProtocol1() && (clazz = MessageSet.getRegisteredClazz(typeId)) != null) {
                item.parseAs(clazz);
            }
            if (!visitor.shouldVisitField(fieldType = !item.isProtocol1() ? new FieldType(typeId) : new FieldType(MessageSet.findCanonicalProtocolMessageClass(item.asProtocol1().getClass()), typeId), 1)) continue;
            visitor.visitForeign(fieldType, 0, item.coerceToProtocol1ForVisitor());
        }
    }

    static void outputTo(GrowableProtocolSink sink, int typeId, GrowableProtocolSink typeValue) {
        sink.putByte((byte)11);
        sink.putByte((byte)16);
        sink.putVarInt(typeId);
        sink.putByte((byte)26);
        sink.putVarInt(typeValue.position());
        sink.putBytes(typeValue.array(), 0, typeValue.position());
        sink.putByte((byte)12);
    }

    public static Class<? extends ProtocolMessage> getRegisteredClazz(int typeId) {
        TypedIdInfo typedIdInfo = (TypedIdInfo)typedIdHash.get(typeId);
        return typedIdInfo != null ? typedIdInfo.clazz : null;
    }

    public static Class<? extends ProtocolMessage> getRegisteredClazz(String typeName) {
        TypedIdInfo typedIdInfo = (TypedIdInfo)typedIdHash.get(typeName);
        return typedIdInfo != null ? typedIdInfo.clazz : null;
    }

    private static RuntimeException newNoTypeIdException(Class<? extends ProtocolMessage> cls) {
        return new RuntimeException("MESSAGE_TYPE_ID not defined for class: " + cls.getName());
    }

    private static Class<? extends ProtocolMessage> findCanonicalProtocolMessageClass(Class<? extends ProtocolMessage> clazz) {
        Class<? extends ProtocolMessage> next;
        while ((next = clazz.getSuperclass()) != ProtocolMessage.class) {
            clazz = next;
        }
        return clazz;
    }

    public static int getTypeId(Class<? extends ProtocolMessage> clazz) {
        TypedIdInfo typedIdInfo = (TypedIdInfo)typedIdHash.get(clazz);
        if (typedIdInfo == null) {
            ProtocolSupport.newInstance(clazz);
            typedIdInfo = (TypedIdInfo)typedIdHash.get(clazz);
            if (typedIdInfo == null) {
                LOG.warning(String.format("Class %s has no type id", clazz.getName()));
                typedIdInfo = new TypedIdInfo(clazz, null, 0);
                typedIdHash.put(clazz, typedIdInfo);
            }
        }
        return typedIdInfo.typeId;
    }

    public static int getTypeIdForMessage(ProtocolMessage message) {
        return MessageSet.getTypeId(MessageSet.findCanonicalProtocolMessageClass(message.getClass()));
    }

    static void setAllowMessageSetNameAndTypeDuplicates(boolean value) {
        allowDuplicates = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerTypeId(Class<? extends ProtocolMessage> clazz, int typeId, String name) {
        TypedIdInfo typedIdInfo = new TypedIdInfo(clazz, name, typeId);
        ConcurrentMap<Object, TypedIdInfo> concurrentMap = typedIdHash;
        synchronized (concurrentMap) {
            typedIdHash.put(clazz, typedIdInfo);
            if (allowDuplicates) {
                typedIdHash.put(name, typedIdInfo);
                typedIdHash.put(typeId, typedIdInfo);
            } else {
                TypedIdInfo oldInfo = typedIdHash.putIfAbsent(name, typedIdInfo);
                if (oldInfo != null && !oldInfo.equals(typedIdInfo)) {
                    LOG.warning(String.format("Class %s has an ambiguous external name", clazz.getName()));
                    typedIdHash.put(name, TYPED_ID_ERROR);
                }
                if ((oldInfo = typedIdHash.putIfAbsent(typeId, typedIdInfo)) != null && !oldInfo.equals(typedIdInfo)) {
                    LOG.severe(String.format("Class %s has an ambiguous MESSAGE_TYPE_ID", clazz.getName()));
                    typedIdHash.put(typeId, TYPED_ID_ERROR);
                }
            }
        }
    }

    static Class<? extends ProtocolMessage> findClass(String name) {
        TypedIdInfo typedIdInfo = (TypedIdInfo)typedIdHash.get(name);
        if (typedIdInfo == null) {
            return null;
        }
        if (typedIdInfo.clazz == null) {
            throw new RuntimeException("Ambiguous name: " + name);
        }
        return typedIdInfo.clazz;
    }

    @Override
    public MessageSet freeze() {
        for (Item item : this.items.values()) {
            if (!item.isProtocol1()) continue;
            item.message = item.asProtocol1().freeze();
        }
        return this;
    }

    @Override
    public MessageSet unfreeze() {
        for (Item item : this.items.values()) {
            if (!item.isProtocol1()) continue;
            item.message = item.asProtocol1().unfreeze();
        }
        return this;
    }

    @Override
    public boolean isFrozen() {
        for (Item item : this.items.values()) {
            if (!item.isProtocol1() || !item.asProtocol1().isFrozen()) continue;
            return true;
        }
        return false;
    }

    static {
        typedIdHash = Maps.newConcurrentMap();
        TYPED_ID_ERROR = new TypedIdInfo(null, null, 0);
        allowDuplicates = false;
    }

    private static class TypedIdInfo {
        final Class<? extends ProtocolMessage> clazz;
        final String name;
        final int typeId;

        public TypedIdInfo(Class<? extends ProtocolMessage> clazz, String name, int typeId) {
            this.clazz = clazz;
            this.name = name;
            this.typeId = typeId;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TypedIdInfo)) {
                return false;
            }
            TypedIdInfo info = (TypedIdInfo)obj;
            if (this.typeId != info.typeId) {
                return false;
            }
            if (this.clazz != info.clazz) {
                return false;
            }
            return this.name != null && this.name.equals(info.name);
        }

        public int hashCode() {
            throw new RuntimeException("Do not use TypedIdInfo as hash table keys.");
        }
    }

    private static class Item
    implements Serializable {
        Object message;
        ItemType messageType;

        Item() {
        }

        static Item from(ProtocolMessage message) {
            Preconditions.checkNotNull(message);
            Item result = new Item();
            result.message = message;
            result.messageType = ItemType.PROTOCOL1;
            return result;
        }

        static Item from(MessageLite message) {
            Preconditions.checkNotNull(message);
            Item result = new Item();
            result.message = message;
            result.messageType = message instanceof ProtocolMessage ? ItemType.PROTOCOL1 : ItemType.PROTOCOL2;
            return result;
        }

        boolean parseAs(Class<? extends ProtocolMessage> newMessageClass) {
            if (this.isProtocol1()) {
                return newMessageClass.isInstance(this.message);
            }
            if (this.isProtocol2()) {
                return false;
            }
            ProtocolMessage prototype = ProtocolSupport.newInstance(newMessageClass);
            return this.convertByteArrayAs(prototype);
        }

        boolean parseAs(MessageLite prototype) {
            if (this.isProtocol1() || this.isProtocol2()) {
                MessageLite messageDefaultInstance;
                MessageLite protoDefaultInstance = prototype.getDefaultInstanceForType();
                return protoDefaultInstance == (messageDefaultInstance = this.asParsedMessage().getDefaultInstanceForType());
            }
            return this.convertByteArrayAs(prototype);
        }

        private boolean convertByteArrayAs(MessageLite prototype) {
            Preconditions.checkState(this.isByteArray());
            try {
                this.message = prototype.newBuilderForType().mergeFrom(this.asByteArray()).buildPartial();
                this.messageType = this.message instanceof ProtocolMessage ? ItemType.PROTOCOL1 : ItemType.PROTOCOL2;
            }
            catch (InvalidProtocolBufferException e) {
                LOG.warning("Parse error in message inside MessageSet.  Tried to parse as: " + prototype.getClass().getName());
                return false;
            }
            return true;
        }

        void mergeFrom(Item that) {
            if (this.isProtocol1()) {
                if (that.parseAs(this.asProtocol1())) {
                    this.message = this.asProtocol1().mergeFrom(that.asProtocol1());
                }
            } else if (this.isProtocol2()) {
                if (that.parseAs(this.asProtocol2())) {
                    this.message = this.asProtocol2().toBuilder().mergeFrom(that.asProtocol2()).buildPartial();
                }
            } else if (that.isProtocol1()) {
                this.message = this.parseAs(that.asProtocol1()) ? this.asProtocol1().mergeFrom(that.asProtocol1()) : that.asProtocol1().clone();
                this.messageType = ItemType.PROTOCOL1;
            } else if (that.isProtocol2()) {
                this.message = this.parseAs(that.asProtocol2()) ? this.asProtocol2().toBuilder().mergeFrom(that.asProtocol2()).buildPartial() : that.message;
                this.messageType = ItemType.PROTOCOL1;
            } else {
                byte[] thisByteString = this.asByteArray();
                byte[] thatByteString = that.asByteArray();
                if (thatByteString.length > 0) {
                    this.message = Bytes.concat((byte[][])new byte[][]{thisByteString, thatByteString});
                }
            }
        }

        Item copy() {
            Item result = new Item();
            result.message = this.isProtocol1() ? this.asProtocol1().clone() : this.message;
            result.messageType = this.messageType;
            return result;
        }

        boolean equals(Item that) {
            if (this.isByteArray()) {
                if (that.isByteArray()) {
                    return Arrays.equals(this.asByteArray(), that.asByteArray());
                }
                return this.parseAs(that.asParsedMessage()) && this.message.equals(that.message);
            }
            if (that.isByteArray()) {
                return that.parseAs(this.asParsedMessage()) && this.message.equals(that.message);
            }
            return this.message.equals(that.message);
        }

        public int hashCode() {
            throw new RuntimeException("Do not use MessageSets as hash table keys.");
        }

        public boolean equals(Object that) {
            return that instanceof Item && this.equals((Item)that);
        }

        boolean isInitialized() {
            return this.isByteArray() || this.asParsedMessage().isInitialized();
        }

        int encodingSize() {
            return this.isByteArray() ? this.asByteArray().length : this.asParsedMessage().getSerializedSize();
        }

        int maxEncodingSize() {
            switch (this.messageType) {
                case PROTOCOL1: {
                    return this.asProtocol1().maxEncodingSize();
                }
                case PROTOCOL2: {
                    return this.asProtocol2().getSerializedSize();
                }
            }
            return this.asByteArray().length;
        }

        void output(ProtocolSink sink) {
            switch (this.messageType) {
                case PROTOCOL1: {
                    this.asProtocol1().outputTo(sink);
                    break;
                }
                case PROTOCOL2: {
                    Message message = this.asProtocol2();
                    int encodingSize = message.getSerializedSize();
                    CodedOutputStream cos = CodedOutputStream.newInstance(sink.array(), sink.position(), encodingSize);
                    try {
                        message.writeTo(cos);
                    }
                    catch (IOException e) {
                        throw new IndexOutOfBoundsException();
                    }
                    sink.skip(encodingSize);
                    break;
                }
                default: {
                    sink.putBytes(this.asByteArray());
                }
            }
        }

        static int decode(ProtocolSource source, Item item) {
            byte[] rawBytes = null;
            int typeId = 0;
            block8: while (true) {
                int tag = source.getVarInt();
                switch (tag) {
                    case 0: {
                        return 0;
                    }
                    case 16: {
                        typeId = source.getVarInt();
                        continue block8;
                    }
                    case 26: {
                        int len = source.getVarInt();
                        rawBytes = new byte[len];
                        try {
                            source.getBytes(rawBytes, 0, len);
                            continue block8;
                        }
                        catch (IndexOutOfBoundsException e) {
                            return 0;
                        }
                    }
                    case 12: {
                        if (typeId != 0 && rawBytes != null) {
                            item.message = rawBytes;
                            item.messageType = ItemType.BYTE_ARRAY;
                            return typeId;
                        }
                        return 0;
                    }
                }
                source.skipData(tag);
            }
        }

        boolean isProtocol1() {
            return this.messageType == ItemType.PROTOCOL1;
        }

        boolean isProtocol2() {
            return this.messageType == ItemType.PROTOCOL2;
        }

        boolean isByteArray() {
            return this.messageType == ItemType.BYTE_ARRAY;
        }

        ProtocolMessage asProtocol1() {
            assert (this.messageType == ItemType.PROTOCOL1);
            return (ProtocolMessage)this.message;
        }

        Message asProtocol2() {
            assert (this.messageType == ItemType.PROTOCOL2);
            return (Message)this.message;
        }

        MessageLite asParsedMessage() {
            assert (this.messageType == ItemType.PROTOCOL1 || this.messageType == ItemType.PROTOCOL2);
            return (MessageLite)this.message;
        }

        byte[] asByteArray() {
            assert (this.messageType == ItemType.BYTE_ARRAY);
            return (byte[])this.message;
        }

        public ProtocolMessage coerceToProtocol1ForVisitor() {
            switch (this.messageType) {
                case PROTOCOL1: {
                    return this.asProtocol1();
                }
                case PROTOCOL2: {
                    RawMessage rawMessage = new RawMessage();
                    rawMessage.mergeFrom(this.asProtocol2().toByteArray());
                    return rawMessage;
                }
            }
            RawMessage rawMessage = new RawMessage();
            rawMessage.mergeFrom(this.asByteArray());
            return rawMessage;
        }

        static enum ItemType {
            PROTOCOL1,
            PROTOCOL2,
            BYTE_ARRAY;

        }
    }

    public static class FieldType
    extends ProtocolType.FieldType {
        public FieldType(Class<? extends ProtocolMessage> cls, int typeId) {
            super(FieldType.getFieldTypeClassName(cls), cls.getName(), typeId, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.OPTIONAL, cls);
        }

        public FieldType(int typeId) {
            super(String.valueOf(typeId), String.valueOf(typeId), typeId, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.OPTIONAL, RawMessage.class);
        }

        @Override
        public int size(ProtocolMessage message) {
            return ((MessageSet)message).items.containsKey(this.getTag()) ? 1 : 0;
        }

        @Override
        public void visit(ProtocolMessage message, ProtocolType.Visitor visitor) {
            MessageSet messageSet = (MessageSet)message;
            Item item = (Item)messageSet.items.get(this.getTag());
            if (!visitor.shouldVisitField(this, item == null ? 0 : 1)) {
                return;
            }
            if (item != null) {
                visitor.visitForeign(this, 0, item.coerceToProtocol1ForVisitor());
            }
        }

        @Override
        public Object getSingleValue(ProtocolMessage message) {
            return ((MessageSet)message).get(this.getTag());
        }

        private static String getFieldTypeClassName(Class<? extends ProtocolMessage> cls) {
            TypedIdInfo idInfo = (TypedIdInfo)typedIdHash.get(cls);
            if (idInfo != null) {
                return idInfo.name;
            }
            return cls.getName();
        }
    }
}

