/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc;

import com.google.cloud.sql.jdbc.Driver;
import com.google.cloud.sql.jdbc.internal.ConnectionProperty;
import com.google.cloud.sql.jdbc.internal.Wrapper;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;

public abstract class GoogleDataSource
extends Wrapper
implements DataSource {
    private final Driver driver;
    private PrintWriter out;
    private int loginTimeoutSeconds;
    private int queryTimeoutSeconds;
    private String instance;
    private String database;

    protected GoogleDataSource(Driver driver) {
        this.driver = driver;
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.out;
    }

    @Override
    public void setLogWriter(PrintWriter out) {
        this.out = out;
    }

    @Override
    public void setLoginTimeout(int seconds) {
        this.loginTimeoutSeconds = seconds;
    }

    @Override
    public int getLoginTimeout() {
        return this.loginTimeoutSeconds;
    }

    public void setQueryTimeout(int seconds) {
        this.queryTimeoutSeconds = seconds;
    }

    public int getQueryTimeout() {
        return this.queryTimeoutSeconds;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Properties props = new Properties();
        if (username != null) {
            props.setProperty(ConnectionProperty.USER.key(), username);
        }
        if (password != null) {
            props.setProperty(ConnectionProperty.PASSWORD.key(), password);
        }
        if (this.database != null) {
            props.setProperty(ConnectionProperty.DATABASE.key(), this.database);
        }
        if (this.queryTimeoutSeconds != 0) {
            props.setProperty(ConnectionProperty.QUERY_TIMEOUT_SECONDS.key(), Integer.toString(this.queryTimeoutSeconds));
        }
        if (this.loginTimeoutSeconds != 0) {
            props.setProperty(ConnectionProperty.CONNECT_TIMEOUT_SECONDS.key(), Integer.toString(this.loginTimeoutSeconds));
        }
        return this.driver.connect(this.createUrl(), props);
    }

    private String createUrl() {
        return String.format("jdbc:google:rdbms://%s", this.instance);
    }
}

