/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.tool.connections;

import com.google.appengine.repackaged.com.google.common.base.Supplier;
import com.google.appengine.repackaged.com.google.common.base.Suppliers;
import com.google.appengine.repackaged.com.google.common.flags.Flag;
import com.google.appengine.repackaged.com.google.common.flags.FlagSpec;
import com.google.cloud.sql.tool.connections.ConnectionFactory;
import com.google.cloud.sql.tool.connections.ConsoleSupplier;

public abstract class CredentialsConnectionFactory
implements ConnectionFactory {
    @FlagSpec(help="Google username (i.e. sqlman@gmail.com) to use to authenticate to the SQL instance.", altName="google_username")
    private static final Flag<String> googleUser = Flag.value("");
    private final String username = googleUser.get();

    protected Supplier<String> getUsernameSupplier(String prompt) {
        if (this.username == null || this.username.isEmpty()) {
            return new ConsoleSupplier(prompt);
        }
        return Suppliers.ofInstance(this.username);
    }

    protected Supplier<String> getPasswordPrompter(String prompt) {
        return new ConsolePasswordSupplier(prompt);
    }

    static class ConsolePasswordSupplier
    extends ConsoleSupplier {
        ConsolePasswordSupplier(String prompt) {
            super(prompt);
        }

        @Override
        public String get() {
            return new String(System.console().readPassword("%s: ", this.prompt));
        }
    }
}

