/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.backends.dev;

import com.google.appengine.repackaged.com.google.common.base.Join;
import com.google.apphosting.utils.config.BackendsXml;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public interface LocalServerController {
    public static final String BACKEND_CONTROLLER_ATTRIBUTE_KEY = "com.google.appengine.dev.backend_controller";

    public TreeMap<String, BackendStateInfo> getBackendState(String var1);

    public void stopBackend(String var1) throws IllegalStateException, Exception;

    public void startBackend(String var1) throws IllegalStateException;

    public static class BackendStateInfo {
        private final BackendsXml.Entry entry;
        private String address;
        private String state;
        private TreeSet<InstanceStateInfo> instanceStates;

        public BackendStateInfo(BackendsXml.Entry entry) {
            this.entry = entry;
            this.instanceStates = new TreeSet();
        }

        public void add(InstanceStateInfo instanceStateInfo) {
            this.instanceStates.add(instanceStateInfo);
        }

        public String getAddress() {
            return this.address;
        }

        public Set<InstanceStateInfo> getInstanceStates() {
            return this.instanceStates;
        }

        public String getInstanceClass() {
            return this.entry.getInstanceClass();
        }

        public String getName() {
            return this.entry.getName();
        }

        public int getNumInstances() {
            return this.entry.getInstances();
        }

        public String getOptionString() {
            ArrayList<String> optionNames = new ArrayList<String>();
            for (BackendsXml.Option option : this.entry.getOptions()) {
                optionNames.add(option.getYamlValue());
            }
            return Join.join((String)", ", optionNames);
        }

        public String getState() {
            return this.state;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public void setState(String state) {
            this.state = state;
        }
    }

    public static class InstanceStateInfo
    implements Comparable<InstanceStateInfo> {
        private final String address;
        private final int instanceNumber;
        private final String state;

        public InstanceStateInfo(int instanceNumber, String address, String state) {
            this.instanceNumber = instanceNumber;
            this.address = address;
            this.state = state;
        }

        public String getAddress() {
            return this.address;
        }

        public int getInstanceNumber() {
            return this.instanceNumber;
        }

        public String getState() {
            return this.state;
        }

        @Override
        public int compareTo(InstanceStateInfo that) {
            return Integer.valueOf(this.instanceNumber).compareTo(that.instanceNumber);
        }
    }
}

