/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.log.dev;

import com.google.appengine.api.log.dev.LocalLogService;
import com.google.apphosting.api.ApiProxy;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class DevLogHandler
extends StreamHandler {
    LocalLogService service = null;

    public DevLogHandler(LocalLogService serviceToUse) {
        this.service = serviceToUse;
    }

    @Override
    public void publish(LogRecord record) {
        this.service.addAppLogLine(DevLogHandler.getRequestId(), record.getMillis(), this.convertLogLevel(record.getLevel()), record.getMessage());
        super.publish(record);
    }

    public int convertLogLevel(Level level) {
        if (level == Level.FINEST || level == Level.FINER || level == Level.FINE) {
            return 0;
        }
        if (level == Level.CONFIG) {
            return 1;
        }
        if (level == Level.INFO) {
            return 2;
        }
        if (level == Level.WARNING) {
            return 3;
        }
        return 4;
    }

    public static String getRequestId() {
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        if (environment == null) {
            return "0";
        }
        Map attrs = environment.getAttributes();
        String internalRequestId = (String)attrs.get("com.google.appengine.tools.development.request_id");
        if (internalRequestId == null) {
            return "0";
        }
        String[] requestIdInfo = internalRequestId.split(",");
        return requestIdInfo[1];
    }
}

