/**********************************************************************
Copyright (c) 2010 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
   ...
**********************************************************************/
package org.datanucleus.query.typesafe;

import java.util.Collection;

/**
 * Representation of a collection in a query.
 * 
 * @param <T> Java type being represented here
 * @param <E> Element type of the collection being represented here
 */
public interface CollectionExpression<T extends Collection<E>, E> extends Expression<T>
{
    /**
     * Method returning whether the specified elementexpression is contained in this collection.
     * @param expr The element expression
     * @return Whether it is contained here
     */
    BooleanExpression contains(Expression expr);

    /**
     * Method returning whether the specified element is contained in this collection.
     * @param elem The element
     * @return Whether it is contained here
     */
    BooleanExpression contains(E elem);

    /**
     * Method returning whether the collection is empty.
     * @return Whether it is empty
     */
    BooleanExpression isEmpty();

    /**
     * Method returning an expression for the size of the collection
     * @return The size
     */
    NumericExpression<Integer> size();
}