/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.search;

import com.google.appengine.repackaged.org.apache.lucene.search.HitCollector;

public class TimeLimitedCollector
extends HitCollector {
    public static final int DEFAULT_RESOLUTION = 20;
    public boolean DEFAULT_GREEDY;
    private static long resolution = 20L;
    private boolean greedy;
    private static final TimerThread TIMER_THREAD = new TimerThread();
    private final long t0;
    private final long timeout;
    private final HitCollector hc;

    public TimeLimitedCollector(HitCollector hc, long timeAllowed) {
        this.greedy = this.DEFAULT_GREEDY = false;
        this.hc = hc;
        this.t0 = TIMER_THREAD.getMilliseconds();
        this.timeout = this.t0 + timeAllowed;
    }

    public void collect(int doc, float score) {
        long time = TIMER_THREAD.getMilliseconds();
        if (this.timeout < time) {
            if (this.greedy) {
                this.hc.collect(doc, score);
            }
            throw new TimeExceededException(this.timeout - this.t0, time - this.t0, doc);
        }
        this.hc.collect(doc, score);
    }

    public static long getResolution() {
        return resolution;
    }

    public static void setResolution(long newResolution) {
        resolution = Math.max(newResolution, 5L);
    }

    public boolean isGreedy() {
        return this.greedy;
    }

    public void setGreedy(boolean greedy) {
        this.greedy = greedy;
    }

    static {
        TIMER_THREAD.start();
    }

    public static class TimeExceededException
    extends RuntimeException {
        private long timeAllowed;
        private long timeElapsed;
        private int lastDocCollected;

        private TimeExceededException(long timeAllowed, long timeElapsed, int lastDocCollected) {
            super("Elapsed time: " + timeElapsed + "Exceeded allowed search time: " + timeAllowed + " ms.");
            this.timeAllowed = timeAllowed;
            this.timeElapsed = timeElapsed;
            this.lastDocCollected = lastDocCollected;
        }

        public long getTimeAllowed() {
            return this.timeAllowed;
        }

        public long getTimeElapsed() {
            return this.timeElapsed;
        }

        public int getLastDocCollected() {
            return this.lastDocCollected;
        }
    }

    private static class TimerThread
    extends Thread {
        private volatile long time = 0L;

        private TimerThread() {
            super("TimeLimitedCollector timer thread");
            this.setDaemon(true);
        }

        public void run() {
            while (true) {
                this.time += resolution;
                try {
                    Thread.sleep(resolution);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(ie);
                }
            }
        }

        public long getMilliseconds() {
            return this.time;
        }
    }
}

