/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.exception;

import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.apphosting.api.DatastorePb;
import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.core.exception.Problem;
import javax.annotation.Nullable;

public final class CanonicalErrorCodeTranslator {
    public static Codes.Code getCanonicalCode(DatastoreException exception) {
        Codes.Code mappedFromProblemCode = CanonicalErrorCodeTranslator.mapProblemCodeToCanonicalCode(exception.getProblem());
        if (mappedFromProblemCode != null) {
            return mappedFromProblemCode;
        }
        Codes.Code mappedFromV3ErrorCode = CanonicalErrorCodeTranslator.mapV3ErrorCodeToCanonicalCode(exception.getErrorCode());
        if (mappedFromV3ErrorCode != null) {
            return mappedFromV3ErrorCode;
        }
        Codes.Code mappedFromMegastoreErrorCode = CanonicalErrorCodeTranslator.mapMegastoreErrorCodeToCanonicalCode(exception.getErrorCode().getValue());
        if (mappedFromMegastoreErrorCode != null) {
            return mappedFromMegastoreErrorCode;
        }
        return Codes.Code.UNKNOWN;
    }

    @Nullable
    private static Codes.Code mapProblemCodeToCanonicalCode(Problem problem) {
        switch (problem.getProblemCode()) {
            case IAM_UNEXPECTED_RESPONSE: {
                return Codes.Code.INTERNAL;
            }
            case CHANGE_LISTENER_LOOKUP_UNAVAILABLE: 
            case CHANGE_LISTENER_PREPARE_FAILED: 
            case IAM_UNAVAILABLE: {
                return Codes.Code.UNAVAILABLE;
            }
            case CHANGE_LISTENER_PREPARE_RESOURCE_EXHAUSTED: {
                return Codes.Code.RESOURCE_EXHAUSTED;
            }
            case SHORT_WRITE_DEADLINE_REJECTION: {
                return Codes.Code.DEADLINE_EXCEEDED;
            }
        }
        return null;
    }

    @Nullable
    private static Codes.Code mapV3ErrorCodeToCanonicalCode(DatastorePb.Error.ErrorCode v3ErrorCode) {
        switch (v3ErrorCode) {
            case BAD_REQUEST: {
                return Codes.Code.INVALID_ARGUMENT;
            }
            case CONCURRENT_TRANSACTION: 
            case ABORTED: {
                return Codes.Code.ABORTED;
            }
            case INTERNAL_ERROR: 
            case COMMITTED_BUT_STILL_APPLYING: {
                return Codes.Code.INTERNAL;
            }
            case NEED_INDEX: 
            case SAFE_TIME_TOO_OLD: 
            case SNAPSHOT_VERSION_TOO_OLD: 
            case FAILED_PRECONDITION: {
                return Codes.Code.FAILED_PRECONDITION;
            }
            case TIMEOUT: 
            case BIGTABLE_ERROR: {
                return Codes.Code.DEADLINE_EXCEEDED;
            }
            case PERMISSION_DENIED: {
                return Codes.Code.PERMISSION_DENIED;
            }
            case CAPABILITY_DISABLED: 
            case TRY_ALTERNATE_BACKEND: {
                return Codes.Code.UNAVAILABLE;
            }
            case RESOURCE_EXHAUSTED: {
                return Codes.Code.RESOURCE_EXHAUSTED;
            }
            case NOT_FOUND: {
                return Codes.Code.NOT_FOUND;
            }
            case ALREADY_EXISTS: {
                return Codes.Code.ALREADY_EXISTS;
            }
            case UNAUTHENTICATED: {
                return Codes.Code.UNAUTHENTICATED;
            }
        }
        return null;
    }

    @Nullable
    private static Codes.Code mapMegastoreErrorCodeToCanonicalCode(int megastoreErrorCode) {
        switch (megastoreErrorCode) {
            case 90000: {
                return Codes.Code.DEADLINE_EXCEEDED;
            }
            case 90001: 
            case 90002: {
                return Codes.Code.INTERNAL;
            }
        }
        return null;
    }
}

