/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.ImplicitTransactionManagementPolicy;
import com.google.appengine.api.datastore.ReadPolicy;
import com.google.appengine.api.datastore.TransactionOptions;
import com.google.appengine.datanucleus.DatastoreAdapter;
import com.google.appengine.datanucleus.DatastoreConnectionFactoryImpl;
import com.google.appengine.datanucleus.DatastorePersistenceHandler;
import com.google.appengine.datanucleus.DatastoreServiceFactoryInternal;
import com.google.appengine.datanucleus.DatastoreTransaction;
import com.google.appengine.datanucleus.EmulatedXAResource;
import com.google.appengine.datanucleus.EntityUtils;
import com.google.appengine.datanucleus.KeyOnlyFieldManager;
import com.google.appengine.datanucleus.MetaDataUtils;
import com.google.appengine.datanucleus.MetaDataValidator;
import com.google.appengine.datanucleus.SerializationManager;
import com.google.appengine.datanucleus.StorageVersion;
import com.google.appengine.datanucleus.TypeConversionUtils;
import com.google.appengine.datanucleus.mapping.DatastoreTable;
import com.google.appengine.datanucleus.scostore.FKListStore;
import com.google.appengine.datanucleus.scostore.FKSetStore;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.NucleusContext;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusFatalUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.store.DefaultCandidateExtent;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.Extent;
import org.datanucleus.store.NucleusConnection;
import org.datanucleus.store.NucleusConnectionImpl;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ConnectionFactory;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.exceptions.NoExtentException;
import org.datanucleus.store.exceptions.NoTableManagedException;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.MappedStoreData;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.scostore.ListStore;
import org.datanucleus.store.scostore.SetStore;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class DatastoreManager
extends MappedStoreManager {
    protected static final Localiser GAE_LOCALISER = Localiser.getInstance((String)"com.google.appengine.datanucleus.Localisation", (ClassLoader)DatastoreManager.class.getClassLoader());
    private static final String EXTENSION_PREFIX = "gae.";
    public static final String PARENT_PK = "gae.parent-pk";
    public static final String ENCODED_PK = "gae.encoded-pk";
    public static final String PK_NAME = "gae.pk-name";
    public static final String PK_ID = "gae.pk-id";
    public static final String UNINDEXED_PROPERTY = "gae.unindexed";
    public static final String DATASTORE_READ_CONSISTENCY_PROPERTY = "datanucleus.appengine.datastoreReadConsistency";
    public static final String DATASTORE_ENABLE_XG_TXNS_PROPERTY = "datanucleus.appengine.datastoreEnableXGTransactions";
    public static final String GET_EXTENT_CAN_RETURN_SUBCLASSES_PROPERTY = "datanucleus.appengine.getExtentCanReturnSubclasses";
    public static final String RELATION_DEFAULT_MODE = "datanucleus.appengine.relationDefault";
    public static final String VALIDATE_METADATA = "datanucleus.appengine.validateMetaData";
    public static final String BIG_DECIMALS_ENCODEING = "datanucleus.appengine.BigDecimalsEncoding";
    public static final String QUERYEXT_SLOW_BUT_MORE_ACCURATE_JPQL_DELETE = "gae.slow-but-more-accurate-jpql-delete-query";
    public static final String QUERYEXT_EXCLUDE_FROM_TXN = "gae.exclude-query-from-txn";
    public static final String QUERYEXT_INMEMORY_WHEN_UNSUPPORTED = "gae.inmemory-when-unsupported";
    private final Set<String> validatedClasses = Collections.synchronizedSet(new HashSet());
    private final Map<String, AbstractMemberMetaData> parentMemberMetaDataByClass = new ConcurrentHashMap<String, AbstractMemberMetaData>();
    private final boolean defaultToOwnedRelations;
    private final TypeConversionUtils typeConversionUtils;
    private final StorageVersion storageVersion;
    private final DatastoreServiceConfig defaultDatastoreServiceConfigPrototypeForReads;
    private final DatastoreServiceConfig defaultDatastoreServiceConfigPrototypeForWrites;
    private final TransactionOptions defaultDatastoreTransactionOptionsPrototype;
    private final DatastoreService datastoreServiceForReads;
    protected SerializationManager serializationMgr = null;
    MetaDataValidator metadataValidator;

    public DatastoreManager(ClassLoaderResolver clr, NucleusContext nucContext, Map<String, Object> props) throws NoSuchFieldException, IllegalAccessException {
        super("appengine", clr, nucContext, props);
        PersistenceConfiguration conf = nucContext.getPersistenceConfiguration();
        conf.setProperty("datanucleus.attachSameDatastore", (Object)Boolean.TRUE.toString());
        conf.setProperty("datanucleus.datastoreTransactionFlushLimit", (Object)Integer.MAX_VALUE);
        conf.setProperty("datanucleus.identityKeyTranslatorType", (Object)"appengine");
        ClassUtils.assertClassForJarExistsInClasspath((ClassLoaderResolver)clr, (String)"com.google.appengine.api.datastore.DatastoreService", (String)"appengine-api.jar");
        this.defaultDatastoreServiceConfigPrototypeForReads = this.createDatastoreServiceConfigPrototypeForReads(nucContext.getPersistenceConfiguration());
        this.defaultDatastoreServiceConfigPrototypeForWrites = this.createDatastoreServiceConfigPrototypeForWrites(nucContext.getPersistenceConfiguration());
        this.defaultDatastoreTransactionOptionsPrototype = this.createDatastoreTransactionOptionsPrototype(nucContext.getPersistenceConfiguration());
        this.persistenceHandler = new DatastorePersistenceHandler((StoreManager)this);
        this.dba = new DatastoreAdapter();
        this.initialiseIdentifierFactory(nucContext);
        this.storageVersion = StorageVersion.fromStoreManager((StoreManager)this);
        String defaultRelationMode = this.getStringProperty(RELATION_DEFAULT_MODE);
        this.defaultToOwnedRelations = !defaultRelationMode.equalsIgnoreCase("unowned");
        String bigDecimalsEncoding = this.getStringProperty(BIG_DECIMALS_ENCODEING);
        this.typeConversionUtils = "String".equalsIgnoreCase(bigDecimalsEncoding) ? new TypeConversionUtils(true) : new TypeConversionUtils(false);
        this.metadataValidator = new MetaDataValidator(this, this.getMetaDataManager(), clr);
        this.initialiseAutoStart(clr);
        this.logConfiguration();
        this.datastoreServiceForReads = DatastoreServiceFactoryInternal.getDatastoreService(this.getDefaultDatastoreServiceConfigForReads());
    }

    public void close() {
        this.validatedClasses.clear();
        super.close();
    }

    public SerializationManager getSerializationManager() {
        if (this.serializationMgr == null) {
            this.serializationMgr = new SerializationManager();
        }
        return this.serializationMgr;
    }

    public boolean isDefaultToOwnedRelations() {
        return this.defaultToOwnedRelations;
    }

    protected void logConfiguration() {
        super.logConfiguration();
        if (NucleusLogger.DATASTORE.isDebugEnabled()) {
            NucleusLogger.DATASTORE.debug((Object)("StorageVersion : " + this.storageVersion.toString()));
            NucleusLogger.DATASTORE.debug((Object)("Default Relation Mode : " + this.getStringProperty(RELATION_DEFAULT_MODE)));
            NucleusLogger.DATASTORE.debug((Object)"===========================================================");
        }
    }

    public void transactionStarted(ExecutionContext ec) {
        if (this.connectionFactoryIsAutoCreateTransaction()) {
            this.getConnection(ec);
        }
    }

    public NucleusConnection getNucleusConnection(ExecutionContext ec) {
        ConnectionFactory cf = this.connectionMgr.lookupConnectionFactory(this.txConnectionFactoryName);
        final boolean enlisted = ec.getTransaction().isActive();
        final ManagedConnection mc = cf.getConnection(enlisted ? ec : null, ec.getTransaction(), null);
        mc.lock();
        Runnable closeRunnable = new Runnable(){

            @Override
            public void run() {
                mc.unlock();
                if (!enlisted) {
                    // empty if block
                }
            }
        };
        return new NucleusConnectionImpl(mc.getConnection(), closeRunnable);
    }

    public Extent getExtent(ExecutionContext ec, Class c, boolean subclasses) {
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(c, ec.getClassLoaderResolver());
        this.validateMetaDataForClass(cmd);
        if (!cmd.isRequiresExtent()) {
            throw new NoExtentException(c.getName());
        }
        if (!this.getBooleanProperty(GET_EXTENT_CAN_RETURN_SUBCLASSES_PROPERTY, false)) {
            subclasses = false;
        }
        return new DefaultCandidateExtent(ec, c, subclasses, cmd);
    }

    public String getDefaultIdentifierCase() {
        return "PreserveCase";
    }

    public Collection<String> getSupportedOptions() {
        HashSet<String> opts = new HashSet<String>();
        opts.add("TransactionIsolationLevel.read-committed");
        opts.add("BackedSCO");
        opts.add("ApplicationIdentity");
        opts.add("DatastoreIdentity");
        opts.add("OptimisticTransaction");
        opts.add("ORM");
        return opts;
    }

    public DatastoreContainerObject newJoinDatastoreContainerObject(AbstractMemberMetaData fmd, ClassLoaderResolver clr) {
        return null;
    }

    protected synchronized StoreData newStoreData(ClassMetaData cmd, ClassLoaderResolver clr) {
        MappedStoreData superData;
        AbstractClassMetaData[] managingCmds;
        InheritanceStrategy strat = cmd.getInheritanceMetaData().getStrategy();
        if (strat == InheritanceStrategy.SUBCLASS_TABLE) {
            return this.buildStoreDataWithNoTable(cmd);
        }
        if (strat == InheritanceStrategy.COMPLETE_TABLE) {
            if (cmd.isAbstract()) {
                return this.buildStoreDataWithNoTable(cmd);
            }
            return this.buildStoreData(cmd, clr);
        }
        if (strat == InheritanceStrategy.NEW_TABLE && (cmd.getSuperAbstractClassMetaData() == null || cmd.getSuperAbstractClassMetaData().getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE)) {
            return this.buildStoreData(cmd, clr);
        }
        if (MetaDataUtils.isNewOrSuperclassTableInheritanceStrategy((AbstractClassMetaData)cmd) && (managingCmds = this.getClassesManagingTableForClass((AbstractClassMetaData)cmd, clr)) != null && managingCmds.length == 1 && (superData = (MappedStoreData)this.storeDataMgr.get(managingCmds[0].getFullClassName())) != null) {
            DatastoreTable superTable = (DatastoreTable)superData.getDatastoreContainerObject();
            return this.buildStoreDataWithTable(cmd, superTable);
        }
        boolean jpa = this.getApiAdapter().getName().equalsIgnoreCase("JPA");
        String unsupportedMsg = GAE_LOCALISER.msg(jpa ? "AppEngine.BadInheritance.JPA" : "AppEngine.BadInheritance.JDO", (Object)cmd.getInheritanceMetaData().getStrategy().toString(), (Object)cmd.getFullClassName(), (Object)this.getApiAdapter().getName());
        throw new UnsupportedInheritanceStrategyException(unsupportedMsg);
    }

    private StoreData buildStoreDataWithNoTable(ClassMetaData cmd) {
        MappedStoreData sdNew = new MappedStoreData(cmd, null, false);
        this.registerStoreData((StoreData)sdNew);
        return sdNew;
    }

    private StoreData buildStoreData(ClassMetaData cmd, ClassLoaderResolver clr) {
        String kindName = EntityUtils.getKindName(this.getIdentifierFactory(), (AbstractClassMetaData)cmd);
        DatastoreTable table = new DatastoreTable(kindName, this, (AbstractClassMetaData)cmd, clr, this.dba);
        MappedStoreData sd = new MappedStoreData(cmd, (DatastoreContainerObject)table, true);
        this.registerStoreData((StoreData)sd);
        table.buildMapping();
        return sd;
    }

    private StoreData buildStoreDataWithTable(ClassMetaData cmd, DatastoreTable table) {
        MappedStoreData sd = new MappedStoreData(cmd, (DatastoreContainerObject)table, false);
        this.registerStoreData((StoreData)sd);
        sd.setDatastoreContainerObject((DatastoreClass)table);
        table.manageClass((AbstractClassMetaData)cmd);
        return sd;
    }

    public Object getResultValueAtPosition(Object key, JavaTypeMapping mapping, int position) {
        return key;
    }

    public boolean insertValuesOnInsert(DatastoreMapping datastoreMapping) {
        return true;
    }

    public boolean allowsBatching() {
        return false;
    }

    public FieldManager getFieldManagerForResultProcessing(ObjectProvider op, Object resultSet, StatementClassMapping resultMappings) {
        ExecutionContext ec = op.getExecutionContext();
        Class cls = ec.getClassLoaderResolver().classForName(op.getClassMetaData().getFullClassName());
        Object internalKey = EntityUtils.idToInternalKey(ec, cls, resultSet, true);
        return new KeyOnlyFieldManager(internalKey);
    }

    public FieldManager getFieldManagerForResultProcessing(ExecutionContext ec, Object resultSet, StatementClassMapping resultMappings, AbstractClassMetaData cmd) {
        Class cls = ec.getClassLoaderResolver().classForName(cmd.getFullClassName());
        Object internalKey = EntityUtils.idToInternalKey(ec, cls, resultSet, true);
        return new KeyOnlyFieldManager(internalKey);
    }

    public FieldManager getFieldManagerForStatementGeneration(ObjectProvider op, Object stmt, StatementClassMapping stmtMappings, boolean checkNonNullable) {
        return null;
    }

    public ResultObjectFactory newResultObjectFactory(AbstractClassMetaData acmd, StatementClassMapping mappingDefinition, boolean ignoreCache, FetchPlan fetchPlan, Class persistentClass) {
        return null;
    }

    protected ListStore newFKListStore(AbstractMemberMetaData ammd, ClassLoaderResolver clr) {
        return new FKListStore(ammd, this, clr);
    }

    protected SetStore newFKSetStore(AbstractMemberMetaData ammd, ClassLoaderResolver clr) {
        return new FKSetStore(ammd, this, clr);
    }

    public boolean usesBackedSCOWrappers() {
        return true;
    }

    public boolean useBackedSCOWrapperForMember(AbstractMemberMetaData mmd, ExecutionContext ec) {
        return mmd.getRelationType(ec.getClassLoaderResolver()) != 0;
    }

    public boolean storageVersionAtLeast(StorageVersion storageVersion) {
        return this.getStorageVersion().ordinal() >= storageVersion.ordinal();
    }

    public TransactionOptions getDefaultDatastoreTransactionOptions() {
        return DatastoreManager.copyTransactionOptions(this.defaultDatastoreTransactionOptionsPrototype);
    }

    public DatastorePersistenceHandler getPersistenceHandler() {
        return (DatastorePersistenceHandler)super.getPersistenceHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastoreTable getDatastoreClass(String className, ClassLoaderResolver clr) {
        try {
            DatastoreManager datastoreManager = this;
            synchronized (datastoreManager) {
                return (DatastoreTable)super.getDatastoreClass(className, clr);
            }
        }
        catch (NoTableManagedException e) {
            Class cls = clr.classForName(className);
            ApiAdapter api = this.getApiAdapter();
            if (cls != null && !cls.isInterface() && !api.isPersistable(cls)) {
                throw new NoTableManagedException("Class " + className + " does not seem to have been enhanced. You may want to rerun " + "the enhancer and check for errors in the output.");
            }
            throw e;
        }
    }

    public void validateMetaDataForClass(AbstractClassMetaData cmd) {
        if (this.validatedClasses.add(cmd.getFullClassName())) {
            AbstractMemberMetaData parentPkMmd;
            if (this.getBooleanProperty(VALIDATE_METADATA, true)) {
                this.metadataValidator.validate(cmd);
            }
            if ((parentPkMmd = MetaDataUtils.getParentPkMemberMetaDataForClass(cmd, this.getMetaDataManager(), this.getNucleusContext().getClassLoaderResolver(cmd.getClass().getClassLoader()))) != null) {
                this.parentMemberMetaDataByClass.put(cmd.getFullClassName(), parentPkMmd);
            }
        }
    }

    public AbstractMemberMetaData getMetaDataForParentPK(AbstractClassMetaData cmd) {
        return this.parentMemberMetaDataByClass.get(cmd.getFullClassName());
    }

    public StorageVersion getStorageVersion() {
        return this.storageVersion;
    }

    public DatastoreTransaction getDatastoreTransaction(ExecutionContext ec) {
        ManagedConnection mconn = ec.getStoreManager().getConnection(ec);
        return ((EmulatedXAResource)mconn.getXAResource()).getCurrentTransaction();
    }

    public DatastoreService getDatastoreService(ExecutionContext ec) {
        ManagedConnection mconn = ec.getStoreManager().getConnection(ec);
        return ((EmulatedXAResource)mconn.getXAResource()).getDatastoreService();
    }

    public DatastoreService getDatastoreServiceForReads(ExecutionContext ec) {
        return this.datastoreServiceForReads;
    }

    public boolean connectionFactoryIsAutoCreateTransaction() {
        DatastoreConnectionFactoryImpl connFactory = (DatastoreConnectionFactoryImpl)this.connectionMgr.lookupConnectionFactory(this.txConnectionFactoryName);
        return connFactory.isAutoCreateTransaction();
    }

    public DatastoreServiceConfig getDefaultDatastoreServiceConfigForReads() {
        return DatastoreManager.copyDatastoreServiceConfig(this.defaultDatastoreServiceConfigPrototypeForReads);
    }

    public DatastoreServiceConfig getDefaultDatastoreServiceConfigForWrites() {
        return DatastoreManager.copyDatastoreServiceConfig(this.defaultDatastoreServiceConfigPrototypeForWrites);
    }

    private DatastoreServiceConfig createDatastoreServiceConfigPrototypeForReads(PersistenceConfiguration persistenceConfig) {
        return this.createDatastoreServiceConfigPrototype(persistenceConfig, "datanucleus.datastoreReadTimeout");
    }

    private DatastoreServiceConfig createDatastoreServiceConfigPrototypeForWrites(PersistenceConfiguration persistenceConfig) {
        return this.createDatastoreServiceConfigPrototype(persistenceConfig, "datanucleus.datastoreWriteTimeout");
    }

    private DatastoreServiceConfig createDatastoreServiceConfigPrototype(PersistenceConfiguration persistenceConfiguration, String ... timeoutProps) {
        DatastoreServiceConfig datastoreServiceConfig = DatastoreServiceConfig.Builder.withDefaults();
        for (String timeoutProp : timeoutProps) {
            int defaultDeadline = persistenceConfiguration.getIntProperty(timeoutProp);
            if (defaultDeadline <= 0) continue;
            datastoreServiceConfig.deadline((double)defaultDeadline / 1000.0);
        }
        String defaultReadConsistencyStr = persistenceConfiguration.getStringProperty(DATASTORE_READ_CONSISTENCY_PROPERTY);
        if (defaultReadConsistencyStr != null) {
            try {
                datastoreServiceConfig.readPolicy(new ReadPolicy(ReadPolicy.Consistency.valueOf((String)defaultReadConsistencyStr)));
            }
            catch (IllegalArgumentException iae) {
                throw new NucleusFatalUserException("Illegal value for datanucleus.appengine.datastoreReadConsistency.  Valid values are " + Arrays.toString(ReadPolicy.Consistency.values()));
            }
        }
        return datastoreServiceConfig;
    }

    private TransactionOptions createDatastoreTransactionOptionsPrototype(PersistenceConfiguration persistenceConfig) {
        return TransactionOptions.Builder.allowMultipleEntityGroups((boolean)persistenceConfig.getBooleanProperty(DATASTORE_ENABLE_XG_TXNS_PROPERTY));
    }

    public TypeConversionUtils getTypeConversionUtils() {
        return this.typeConversionUtils;
    }

    String getTxConnectionFactoryName() {
        return this.txConnectionFactoryName;
    }

    String getNonTxConnectionFactoryName() {
        return this.nontxConnectionFactoryName;
    }

    static DatastoreServiceConfig copyDatastoreServiceConfig(DatastoreServiceConfig config) {
        DatastoreServiceConfig newConfig = DatastoreServiceConfig.Builder.withImplicitTransactionManagementPolicy((ImplicitTransactionManagementPolicy)config.getImplicitTransactionManagementPolicy()).readPolicy(config.getReadPolicy());
        if (config.getDeadline() != null) {
            newConfig.deadline(config.getDeadline().doubleValue());
        }
        return newConfig;
    }

    static TransactionOptions copyTransactionOptions(TransactionOptions txnOpts) {
        TransactionOptions options = TransactionOptions.Builder.withDefaults();
        if (txnOpts.isXG()) {
            options.setXG(txnOpts.isXG());
        } else {
            options.clearXG();
        }
        return txnOpts;
    }

    public static final class UnsupportedInheritanceStrategyException
    extends NucleusFatalUserException {
        UnsupportedInheritanceStrategyException(String msg) {
            super(msg);
        }
    }
}

