/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.enhancer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.NucleusContext;
import org.datanucleus.enhancer.ClassEnhancer;
import org.datanucleus.enhancer.DataNucleusEnhancer;
import org.datanucleus.enhancer.asm.ASMClassEnhancer;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

public class RuntimeEnhancer {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.enhancer.Localisation", (ClassLoader)ClassEnhancer.class.getClassLoader());
    private String api = "JDO";
    private boolean generatePK = true;
    private boolean generateConstructor = true;
    private boolean detachListener = false;
    private ClassLoaderResolver clr;
    private NucleusContext nucleusContext;
    private boolean initialized = false;
    Map<ClassLoader, EnhancerClassLoader> runtimeLoaderByLoader = new HashMap<ClassLoader, EnhancerClassLoader>();

    public byte[] enhance(String className, byte[] classdefinition, ClassLoader loader) {
        EnhancerClassLoader runtimeLoader;
        if (!this.initialized) {
            this.initialize();
        }
        if ((runtimeLoader = this.runtimeLoaderByLoader.get(loader)) == null) {
            runtimeLoader = new EnhancerClassLoader(loader);
            this.runtimeLoaderByLoader.put(loader, runtimeLoader);
        }
        this.clr.setPrimary((ClassLoader)runtimeLoader);
        try {
            Class clazz = null;
            try {
                clazz = this.clr.classForName(className);
            }
            catch (ClassNotResolvedException e1) {
                DataNucleusEnhancer.LOGGER.debug((Object)StringUtils.getStringFromStackTrace((Throwable)e1));
                return null;
            }
            AbstractClassMetaData acmd = this.nucleusContext.getMetaDataManager().getMetaDataForClass(clazz, this.clr);
            if (acmd == null) {
                DataNucleusEnhancer.LOGGER.debug((Object)("Class " + className + " cannot be enhanced because no metadata has been found."));
                return null;
            }
            ASMClassEnhancer classEnhancer = new ASMClassEnhancer((ClassMetaData)acmd, this.clr, this.nucleusContext.getMetaDataManager(), classdefinition);
            ArrayList<String> options = new ArrayList<String>();
            if (this.generatePK) {
                options.add("generate-primary-key");
            }
            if (this.generateConstructor) {
                options.add("generate-default-constructor");
            }
            if (this.detachListener) {
                options.add("generate-detach-listener");
            }
            classEnhancer.setOptions(options);
            classEnhancer.enhance();
            return classEnhancer.getClassBytes();
        }
        catch (Throwable ex) {
            DataNucleusEnhancer.LOGGER.error((Object)StringUtils.getStringFromStackTrace((Throwable)ex));
            return null;
        }
    }

    private synchronized void initialize() {
        this.nucleusContext = new NucleusContext(this.api, NucleusContext.ContextType.ENHANCEMENT, null);
        this.clr = this.nucleusContext.getClassLoaderResolver(null);
        this.initialized = true;
    }

    public void setApi(String api) {
        this.api = api;
    }

    public void setGeneratePK(boolean generatePK) {
        this.generatePK = generatePK;
    }

    public void setGenerateConstructor(boolean generateConstructor) {
        this.generateConstructor = generateConstructor;
    }

    public void setDetachListener(Boolean detachListener) {
        this.detachListener = detachListener;
    }

    public static class EnhancerClassLoader
    extends ClassLoader {
        EnhancerClassLoader(ClassLoader loader) {
            super(loader);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> clazz;
            block13: {
                Class<?> c = super.findLoadedClass(name);
                if (c != null) {
                    return c;
                }
                if (name.startsWith("java.")) {
                    return super.loadClass(name, resolve);
                }
                if (name.startsWith("javax.")) {
                    return super.loadClass(name, resolve);
                }
                if (name.startsWith("org.datanucleus.jpa.annotations") || name.startsWith("org.datanucleus.api.jpa.annotations")) {
                    return super.loadClass(name, resolve);
                }
                String resource = StringUtils.replaceAll((String)name, (String)".", (String)"/") + ".class";
                URL url = super.getResource(resource);
                if (url == null) {
                    throw new ClassNotFoundException(name);
                }
                InputStream is = url.openStream();
                try {
                    int count;
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    byte[] b = new byte[2048];
                    while ((count = is.read(b, 0, 2048)) != -1) {
                        os.write(b, 0, count);
                    }
                    byte[] bytes = os.toByteArray();
                    clazz = this.defineClass(name, bytes, 0, bytes.length);
                    if (is == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            is.close();
                        }
                        throw throwable;
                    }
                    catch (SecurityException e) {
                        return super.loadClass(name, resolve);
                    }
                    catch (IOException e) {
                        throw new ClassNotFoundException(name, e);
                    }
                }
                is.close();
            }
            return clazz;
        }
    }
}

