/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.labs.command;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.flogger.GoogleLogger;
import com.google.appengine.repackaged.com.google.common.labs.command.CommandProcess;
import com.google.appengine.repackaged.com.google.common.labs.command.CommandResult;
import com.google.appengine.repackaged.com.google.common.util.concurrent.AbstractFuture;
import com.google.appengine.repackaged.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.appengine.repackaged.com.google.common.util.concurrent.Uninterruptibles;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.annotation.concurrent.GuardedBy;

final class CommandFuture
extends AbstractFuture<CommandResult> {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/appengine/repackaged/com/google/common/labs/command/CommandFuture");
    private static final Duration POLLING_INTERVAL = Duration.ofMillis(100L);
    private final CommandProcess process;

    CommandFuture(CommandProcess process) {
        this.process = Preconditions.checkNotNull(process);
        CommandQueue.INSTANCE.add(this);
    }

    private boolean checkComplete() {
        if (this.process.isAlive()) {
            return false;
        }
        try {
            this.set(this.process.getDone());
        }
        catch (Throwable t) {
            this.setException(t);
        }
        return true;
    }

    @Override
    protected void afterDone() {
        if (this.wasInterrupted()) {
            this.process.kill();
        }
    }

    private static final class CommandQueue {
        private static final CommandQueue INSTANCE = new CommandQueue();
        private static final Executor EXECUTOR = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("command-queue-%d").build());
        @GuardedBy(value="this")
        private final Set<CommandFuture> futures = new HashSet<CommandFuture>();

        private CommandQueue() {
        }

        private synchronized void add(CommandFuture future) {
            if (this.futures.isEmpty()) {
                EXECUTOR.execute(this::pollUntilComplete);
            }
            this.futures.add(future);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean checkComplete() {
            ImmutableList<CommandFuture> local;
            CommandQueue commandQueue = this;
            synchronized (commandQueue) {
                local = ImmutableList.copyOf(this.futures);
            }
            ArrayList<CommandFuture> finished = new ArrayList<CommandFuture>();
            for (CommandFuture future : local) {
                if (!future.checkComplete()) continue;
                finished.add(future);
            }
            CommandQueue commandQueue2 = this;
            synchronized (commandQueue2) {
                this.futures.removeAll(finished);
                return this.futures.isEmpty();
            }
        }

        private synchronized void cancelAllPending() {
            for (CommandFuture future : this.futures) {
                future.cancel(false);
            }
            this.futures.clear();
        }

        private void pollUntilComplete() {
            block3: {
                try {
                    while (!this.checkComplete()) {
                        Uninterruptibles.sleepUninterruptibly(POLLING_INTERVAL);
                        if (!Thread.interrupted()) continue;
                        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withInjectedLogSite("com/google/appengine/repackaged/com/google/common/labs/command/CommandFuture$CommandQueue", "pollUntilComplete", 133, "CommandFuture.java")).log("Ignoring interruption");
                    }
                }
                catch (Throwable t) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause(t)).withInjectedLogSite("com/google/appengine/repackaged/com/google/common/labs/command/CommandFuture$CommandQueue", "pollUntilComplete", 138, "CommandFuture.java")).log("Unexpected exception killed polling thread, all pending futures cancelled.");
                    this.cancelAllPending();
                    if (!(t instanceof Error)) break block3;
                    throw t;
                }
            }
        }
    }
}

