/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.tools.admin.AdminException;
import com.google.appengine.tools.admin.ClientDeploySender;
import com.google.appengine.tools.admin.HttpIoException;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.YamlUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class ResourceLimits {
    private final Map<String, Long> resourceLimitsMap;
    static final String MAX_BLOB_SIZE_KEY = "max_blob_size";
    static final String MAX_FILE_COUNT_KEY = "max_file_count";
    static final String MAX_FILE_SIZE_KEY = "max_file_size";
    static final String MAX_FILES_TO_CLONE_KEY = "max_files_to_clone";
    static final String MAX_TOTAL_FILE_SIZE_KEY = "max_total_file_size";
    private static final HashMap<String, Long> DEFAULT_RESOURCE_LIMITS = new HashMap();

    private ResourceLimits(Map<String, Long> resourceLimitsMap) {
        this.resourceLimitsMap = resourceLimitsMap;
    }

    public long maxBlobSize() {
        return this.resourceLimitsMap.get(MAX_BLOB_SIZE_KEY);
    }

    public long maxFileCount() {
        return this.resourceLimitsMap.get(MAX_FILE_COUNT_KEY);
    }

    public long maxFileSize() {
        return this.resourceLimitsMap.get(MAX_FILE_SIZE_KEY);
    }

    public long maxFilesToClone() {
        return this.resourceLimitsMap.get(MAX_FILES_TO_CLONE_KEY);
    }

    public long maxTotalFileSize() {
        return this.resourceLimitsMap.get(MAX_TOTAL_FILE_SIZE_KEY);
    }

    public Set<String> keySet() {
        return this.resourceLimitsMap.keySet();
    }

    public long get(String key) {
        return this.resourceLimitsMap.get(key);
    }

    public static ResourceLimits request(ClientDeploySender clientDeploySender, String appId, String version) throws IOException {
        Map<String, Long> remoteResourceLimits = ResourceLimits.remoteRequest(clientDeploySender, appId, version);
        for (Map.Entry<String, Long> defaultEntry : DEFAULT_RESOURCE_LIMITS.entrySet()) {
            if (remoteResourceLimits.containsKey(defaultEntry.getKey())) continue;
            remoteResourceLimits.put(defaultEntry.getKey(), defaultEntry.getValue());
        }
        return new ResourceLimits(remoteResourceLimits);
    }

    private static Map<String, Long> remoteRequest(ClientDeploySender clientDeploySender, String appId, String version) throws IOException {
        String reply = null;
        try {
            reply = clientDeploySender.send("/api/appversion/getresourcelimits", "", "app_id", appId, "version", version);
            return YamlUtils.genericParse(reply, new YamlUtils.ObjectConverter<Long>(){

                @Override
                public Long convert(Object obj) {
                    return Long.parseLong((String)obj);
                }
            });
        }
        catch (AppEngineConfigException exc) {
            String string = String.valueOf(reply);
            throw new AdminException(string.length() != 0 ? "Error parsing YAML: ".concat(string) : new String("Error parsing YAML: "), exc);
        }
        catch (HttpIoException exc) {
            if (exc.getResponseCode() == 404) {
                return new HashMap<String, Long>();
            }
            throw exc;
        }
    }

    static ResourceLimits generate(Map<String, Long> testValues) {
        return new ResourceLimits(testValues);
    }

    static ResourceLimits newDefaultResourceLimits() {
        return new ResourceLimits(DEFAULT_RESOURCE_LIMITS);
    }

    static {
        long MILLION = 1000000L;
        long MEGA = 0x100000L;
        DEFAULT_RESOURCE_LIMITS.put(MAX_BLOB_SIZE_KEY, 32000000L);
        DEFAULT_RESOURCE_LIMITS.put(MAX_FILE_COUNT_KEY, 10000L);
        DEFAULT_RESOURCE_LIMITS.put(MAX_FILE_SIZE_KEY, 32000000L);
        DEFAULT_RESOURCE_LIMITS.put(MAX_FILES_TO_CLONE_KEY, 100L);
        DEFAULT_RESOURCE_LIMITS.put(MAX_TOTAL_FILE_SIZE_KEY, 0x9600000L);
    }
}

