/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.repackaged.com.google.common.labs.command.Command;
import com.google.appengine.repackaged.com.google.common.labs.command.CommandProcess;
import com.google.appengine.repackaged.com.google.common.labs.command.CommandStartException;
import java.io.File;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Utility {
    private static Logger logger = Logger.getLogger(Utility.class.getCanonicalName());
    private static final String FORWARD_SLASH = "/";

    public static boolean isOsUnix() {
        return File.separator.equals(FORWARD_SLASH);
    }

    public static boolean isOsWindows() {
        return !Utility.isOsUnix();
    }

    public static String calculatePath(File f, File base) {
        int offset = base.getPath().length();
        String path = f.getPath().substring(offset);
        if (File.separatorChar == '\\') {
            path = path.replace('\\', '/');
        }
        offset = 0;
        while (path.charAt(offset) == '/') {
            ++offset;
        }
        if (offset > 0) {
            path = path.substring(offset);
        }
        return path;
    }

    public static String jsonEscape(String s) {
        StringBuilder stringBuilder = new StringBuilder();
        block10: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block10;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block10;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block10;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block10;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block10;
                }
                case '/': {
                    stringBuilder.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch >= ' ' && ch < '\u007f') {
                        stringBuilder.append(ch);
                        continue block10;
                    }
                    stringBuilder.append(String.format("\\u%04x", ch));
                }
            }
        }
        return stringBuilder.toString();
    }

    private Utility() {
    }

    static CommandProcess startProcess(PrintWriter detailsWriter, String cmd, String ... args) throws CommandStartException {
        Command command = Command.command(cmd, args).withStdoutAndStderrTo(detailsWriter::println, StandardCharsets.UTF_8);
        logger.logp(Level.FINE, "com.google.appengine.tools.admin.Utility", "startProcess", command::toString);
        return command.start();
    }
}

