/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.devappserver2;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.tools.development.AppContext;
import com.google.appengine.tools.development.ApplicationConfigurationManager;
import com.google.appengine.tools.development.ContainerUtils;
import com.google.appengine.tools.development.DevAppServer;
import com.google.appengine.tools.development.DevAppServerDatastorePropertyHelper;
import com.google.appengine.tools.development.DevAppServerPortPropertyHelper;
import com.google.appengine.tools.development.DevSocketImplFactory;
import com.google.appengine.tools.development.EnvironmentVariableChecker;
import com.google.appengine.tools.development.Modules;
import com.google.appengine.tools.development.StreamHandlerFactory;
import com.google.appengine.tools.development.devappserver2.DevAppServer2Delegate;
import com.google.appengine.tools.info.AppengineSdk;
import com.google.appengine.tools.remoteapi.RemoteApiOptions;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.EarHelper;
import java.io.File;
import java.net.BindException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

class DevAppServer2Impl
implements DevAppServer {
    private static final Logger logger = Logger.getLogger(DevAppServer2Impl.class.getName());
    private final ApplicationConfigurationManager applicationConfigurationManager;
    private final Modules modules;
    private Map<String, String> serviceProperties = new HashMap<String, String>();
    private final Map<String, Object> containerConfigProperties;
    private final int requestedPort;
    private final RemoteApiOptions remoteApiOptions;
    private final String webDefaultXml;
    private ServerState serverState = ServerState.INITIALIZING;
    private final AppEngineConfigException configurationException;
    private final ScheduledExecutorService shutdownScheduler = Executors.newScheduledThreadPool(1);
    private CountDownLatch shutdownLatch = null;
    private DevAppServer2Delegate devAppServer2Delegate;

    DevAppServer2Impl(File appDir, File externalResourceDir, File webXmlLocation, File appEngineWebXmlLocation, String address, int port, boolean useCustomStreamHandler, Map<String, ?> containerConfigProperties) {
        ApplicationConfigurationManager tempManager;
        this.webDefaultXml = "com/google/appengine/tools/development/devappserver2/webdefault/jetty9/webdefault.xml";
        String serverInfo = ContainerUtils.getServerInfo();
        if (useCustomStreamHandler) {
            StreamHandlerFactory.install();
        }
        DevSocketImplFactory.install();
        String remoteApiHost = (String)containerConfigProperties.get("com.google.appengine.apiHost");
        int remoteApiPort = (Integer)containerConfigProperties.get("com.google.appengine.apiPort");
        this.remoteApiOptions = new RemoteApiOptions().server(remoteApiHost, remoteApiPort).credentials("test@example.com", "ignoredpassword");
        this.requestedPort = port;
        AppengineSdk sdk = AppengineSdk.getSdk();
        File schemaFile = new File(sdk.getResourcesDirectory(), "appengine-application.xsd");
        try {
            if (EarHelper.isEar(appDir.getAbsolutePath())) {
                tempManager = ApplicationConfigurationManager.newEarConfigurationManager((File)appDir, (String)sdk.getLocalVersion().getRelease(), (File)schemaFile, (String)"dev~");
                String contextRootWarning = "Ignoring application.xml context-root element, for details see https://developers.google.com/appengine/docs/java/modules/#config";
                logger.logp(Level.INFO, "com.google.appengine.tools.development.devappserver2.DevAppServer2Impl", "<init>", contextRootWarning);
            } else {
                tempManager = ApplicationConfigurationManager.newWarConfigurationManager((File)appDir, (File)appEngineWebXmlLocation, (File)webXmlLocation, (File)externalResourceDir, (String)sdk.getLocalVersion().getRelease(), (String)"dev~");
            }
        }
        catch (AppEngineConfigException configurationException) {
            this.modules = null;
            this.applicationConfigurationManager = null;
            this.containerConfigProperties = null;
            this.configurationException = configurationException;
            return;
        }
        this.applicationConfigurationManager = tempManager;
        this.modules = Modules.createModules((ApplicationConfigurationManager)this.applicationConfigurationManager, (String)serverInfo, (File)externalResourceDir, (String)address, (DevAppServer)this);
        this.containerConfigProperties = ImmutableMap.copyOf(containerConfigProperties);
        this.configurationException = null;
    }

    @Override
    public void setServiceProperties(Map<String, String> properties) {
        if (this.serverState != ServerState.INITIALIZING) {
            String msg = "Cannot set service properties after the server has been started.";
            throw new IllegalStateException(msg);
        }
        if (this.configurationException == null) {
            this.serviceProperties = new ConcurrentHashMap<String, String>(properties);
            this.serviceProperties.put("appengine.webdefault.xml", this.webDefaultXml);
            if (this.requestedPort != 0) {
                DevAppServerPortPropertyHelper.setPort((String)this.modules.getMainModule().getModuleName(), (int)this.requestedPort, this.serviceProperties);
            }
            DevAppServerDatastorePropertyHelper.setDefaultProperties(this.serviceProperties);
        }
    }

    @Override
    public Map<String, String> getServiceProperties() {
        return this.serviceProperties;
    }

    @Override
    public CountDownLatch start() throws Exception {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<CountDownLatch>(){

                @Override
                public CountDownLatch run() throws Exception {
                    return DevAppServer2Impl.this.doStart();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    private CountDownLatch doStart() throws Exception {
        if (this.serverState != ServerState.INITIALIZING) {
            throw new IllegalStateException("Cannot start a server that has already been started.");
        }
        this.reportDeferredConfigurationException();
        this.initializeLogging();
        this.modules.configure(this.containerConfigProperties);
        try {
            this.modules.createConnections();
        }
        catch (BindException ex) {
            System.err.println();
            System.err.println("************************************************");
            String string = String.valueOf(ex.getMessage());
            System.err.println(string.length() != 0 ? "Could not open the requested socket: ".concat(string) : new String("Could not open the requested socket: "));
            System.err.println("Try overriding --address and/or --port.");
            System.exit(2);
        }
        this.devAppServer2Delegate = new DevAppServer2Delegate(this.remoteApiOptions);
        ApiProxy.setDelegate((ApiProxy.Delegate)this.devAppServer2Delegate);
        TimeZone currentTimeZone = null;
        try {
            currentTimeZone = this.setServerTimeZone();
            this.modules.setApiProxyDelegate((ApiProxy.Delegate)this.devAppServer2Delegate);
            this.modules.startup();
        }
        finally {
            this.restoreLocalTimeZone(currentTimeZone);
        }
        this.shutdownLatch = new CountDownLatch(1);
        this.serverState = ServerState.RUNNING;
        logger.logp(Level.INFO, "com.google.appengine.tools.development.devappserver2.DevAppServer2Impl", "doStart", "Dev App Server is now running");
        return this.shutdownLatch;
    }

    private TimeZone setServerTimeZone() {
        String sysTimeZone = this.serviceProperties.get("appengine.user.timezone.impl");
        if (sysTimeZone != null && sysTimeZone.trim().length() > 0) {
            return null;
        }
        TimeZone utc = TimeZone.getTimeZone("UTC");
        assert (utc.getID().equals("UTC")) : "Unable to retrieve the UTC TimeZone";
        TimeZone previousZone = TimeZone.getDefault();
        TimeZone.setDefault(utc);
        return previousZone;
    }

    private void restoreLocalTimeZone(TimeZone timeZone) {
        String sysTimeZone = this.serviceProperties.get("appengine.user.timezone.impl");
        if (sysTimeZone != null && sysTimeZone.trim().length() > 0) {
            return;
        }
        TimeZone.setDefault(timeZone);
    }

    @Override
    public CountDownLatch restart() throws Exception {
        if (this.serverState != ServerState.RUNNING) {
            throw new IllegalStateException("Cannot restart a server that is not currently running.");
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<CountDownLatch>(){

                @Override
                public CountDownLatch run() throws Exception {
                    DevAppServer2Impl.this.modules.shutdown();
                    DevAppServer2Impl.this.shutdownLatch.countDown();
                    DevAppServer2Impl.this.modules.createConnections();
                    DevAppServer2Impl.this.modules.setApiProxyDelegate((ApiProxy.Delegate)DevAppServer2Impl.this.devAppServer2Delegate);
                    DevAppServer2Impl.this.modules.startup();
                    DevAppServer2Impl.this.shutdownLatch = new CountDownLatch(1);
                    return DevAppServer2Impl.this.shutdownLatch;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    @Override
    public void shutdown() throws Exception {
        if (this.serverState != ServerState.RUNNING) {
            throw new IllegalStateException("Cannot shutdown a server that is not currently running.");
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    DevAppServer2Impl.this.modules.shutdown();
                    ApiProxy.setDelegate(null);
                    DevAppServer2Impl.this.serverState = ServerState.SHUTDOWN;
                    DevAppServer2Impl.this.shutdownLatch.countDown();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    @Override
    public void gracefulShutdown() throws IllegalStateException {
        AccessController.doPrivileged(new PrivilegedAction<Future<Void>>(){

            @Override
            public Future<Void> run() {
                return DevAppServer2Impl.this.shutdownScheduler.schedule(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        DevAppServer2Impl.this.shutdown();
                        return null;
                    }
                }, 1000L, TimeUnit.MILLISECONDS);
            }
        });
    }

    @Override
    public int getPort() {
        this.reportDeferredConfigurationException();
        return this.modules.getMainModule().getMainContainer().getPort();
    }

    protected void reportDeferredConfigurationException() {
        if (this.configurationException != null) {
            throw new AppEngineConfigException("Invalid configuration", this.configurationException);
        }
    }

    @Override
    public AppContext getAppContext() {
        this.reportDeferredConfigurationException();
        return this.modules.getMainModule().getMainContainer().getAppContext();
    }

    @Override
    public AppContext getCurrentAppContext() {
        AppContext result = null;
        ApiProxy.Environment env = ApiProxy.getCurrentEnvironment();
        if (env != null && env.getVersionId() != null) {
            String moduleName = env.getModuleId();
            result = this.modules.getModule(moduleName).getMainContainer().getAppContext();
        }
        return result;
    }

    @Override
    public void setThrowOnEnvironmentVariableMismatch(boolean throwOnMismatch) {
        if (this.configurationException == null) {
            this.applicationConfigurationManager.setEnvironmentVariableMismatchReportingPolicy(throwOnMismatch ? EnvironmentVariableChecker.MismatchReportingPolicy.EXCEPTION : EnvironmentVariableChecker.MismatchReportingPolicy.LOG);
        }
    }

    private void initializeLogging() {
        for (Handler handler : Logger.getLogger("").getHandlers()) {
            if (!(handler instanceof ConsoleHandler)) continue;
            handler.setLevel(Level.FINEST);
        }
    }

    static enum ServerState {
        INITIALIZING,
        RUNNING,
        STOPPING,
        SHUTDOWN;

    }
}

