/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.info;

import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.repackaged.com.google.common.collect.ListMultimap;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.tools.info.AppengineSdk;
import java.io.File;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class MavenSdk
extends AppengineSdk {
    private final ListMultimap<String, File> profileToFiles;
    private final String resourceFile;
    private boolean includeTestingJarOnSharedPath = false;

    public MavenSdk(ListMultimap<String, File> profileToFiles) {
        this.profileToFiles = profileToFiles;
        this.resourceFile = this.getSingletonFile("Resources").toString();
    }

    @Override
    public void includeTestingJarOnSharedPath(boolean val) {
        this.includeTestingJarOnSharedPath = val;
    }

    @Override
    public File getToolsApiJarFile() {
        return this.getSingletonFile("ToolsApi");
    }

    @Override
    public List<File> getUserJspLibFiles() {
        String string = String.valueOf(MavenSdk.getJettySuffix());
        return this.profileToFiles.get((Object)(string.length() != 0 ? "UserJsp".concat(string) : new String("UserJsp")));
    }

    @Override
    public List<File> getUserLibFiles() {
        return Collections.emptyList();
    }

    @Override
    public String getQuickStartClasspath(AppengineSdk.WebDefaultXmlType jettyVersion) {
        List<String> classes = Lists.transform(this.profileToFiles.get((Object)"QuickStart"), new Function<File, String>(this){

            @Override
            public String apply(File file) {
                return file.getAbsolutePath();
            }
        });
        return Joiner.on(System.getProperty("path.separator")).join(classes);
    }

    @Override
    public List<File> getSharedJspLibFiles() {
        String string = String.valueOf(MavenSdk.getJettySuffix());
        return this.profileToFiles.get((Object)(string.length() != 0 ? "SharedJsp".concat(string) : new String("SharedJsp")));
    }

    @Override
    public List<URL> getImplLibs() {
        String string = String.valueOf(MavenSdk.getJettySuffix());
        return this.toURLs((List<File>)this.profileToFiles.get((Object)(string.length() != 0 ? "Impl".concat(string) : new String("Impl"))));
    }

    @Override
    public List<File> getSharedLibFiles() {
        String string = String.valueOf(MavenSdk.getJettySuffix());
        Collection sharedLibFiles = this.profileToFiles.get((Object)(string.length() != 0 ? "Shared".concat(string) : new String("Shared")));
        if (this.includeTestingJarOnSharedPath) {
            sharedLibFiles.addAll(this.profileToFiles.get((Object)"Testing"));
        }
        return sharedLibFiles;
    }

    @Override
    public List<URL> getDatanucleusLibs(String version) {
        if (!version.equals("v2")) {
            String string = String.valueOf(version);
            throw new IllegalArgumentException(string.length() != 0 ? "Only Datanucleus v2 is supported. Invalid version: ".concat(string) : new String("Only Datanucleus v2 is supported. Invalid version: "));
        }
        return this.toURLs((List<File>)this.profileToFiles.get((Object)"Datanucleus"));
    }

    @Override
    public String getWebDefaultXml(AppengineSdk.WebDefaultXmlType jettyVersion) {
        String string = String.valueOf((Object)jettyVersion);
        return new File(this.resourceFile, new StringBuilder(15 + String.valueOf(string).length()).append(string).append("/webdefault.xml").toString()).toString();
    }

    @Override
    public File getResourcesDirectory() {
        return new File(this.resourceFile, "docs");
    }

    @Override
    public File getAgentJarFile() {
        return this.getSingletonFile("Agent");
    }

    @Override
    public List<URL> getSharedLibs() {
        return this.toURLs(this.getSharedLibFiles());
    }

    @Override
    public List<URL> getWebApiToolsLibs() {
        return this.toURLs((List<File>)this.profileToFiles.get((Object)"WebApiTool"));
    }

    @Override
    public File getLoggingProperties() {
        return Paths.get(this.resourceFile, "config", "sdk", "logging.properties").toFile();
    }

    private static String getJettySuffix() {
        return "Jetty9";
    }

    private File getSingletonFile(String profile) {
        try {
            return (File)this.profileToFiles.get((Object)profile).get(0);
        }
        catch (Exception ex) {
            throw new IllegalStateException(new StringBuilder(75 + String.valueOf(profile).length()).append("The profiles map must include a \"").append(profile).append("\" key corresponding a singleton file list.").toString());
        }
    }
}

