/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.ApplicationXml;
import com.google.apphosting.utils.config.XmlUtils;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ApplicationXmlReader {
    public ApplicationXml processXml(InputStream is) {
        ApplicationXml.Builder builder = ApplicationXml.builder();
        HashSet<String> contextRoots = new HashSet<String>();
        Element root = XmlUtils.parseXml(is).getDocumentElement();
        NodeList nodes = root.getChildNodes();
        block12: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            Element elt = (Element)node;
            switch (elt.getTagName()) {
                case "icon": 
                case "display-name": 
                case "description": 
                case "module": {
                    this.handleModuleNode(elt, builder.getModulesBuilder(), contextRoots);
                    continue block12;
                }
                case "security-role": 
                case "library-directory": {
                    continue block12;
                }
                default: {
                    this.reportUnrecognizedTag(elt.getTagName());
                }
            }
        }
        return builder.build();
    }

    private void handleModuleNode(Element root, ApplicationXml.Modules.Builder builder, Set<String> contextRoots) {
        NodeList nodes = root.getChildNodes();
        block11: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            Element elt = (Element)node;
            switch (elt.getTagName()) {
                case "alt-dd": 
                case "connector": 
                case "ejb": 
                case "java": {
                    continue block11;
                }
                case "web": {
                    this.handleWebNode(elt, builder, contextRoots);
                    continue block11;
                }
                default: {
                    this.reportUnrecognizedTag(elt.getTagName());
                }
            }
        }
    }

    private void handleWebNode(Element root, ApplicationXml.Modules.Builder builder, Set<String> contextRoots) {
        String contextRoot = null;
        String webUri = null;
        String string = root.getTagName();
        String what = new StringBuilder(26 + String.valueOf(string).length()).append("application.xml <").append(string).append("> element").toString();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            Element elt = (Element)node;
            if ("web-uri".equals(elt.getTagName())) {
                if (webUri != null) {
                    throw new AppEngineConfigException("web-uri multiply defined in application.xml web module.");
                }
                webUri = XmlUtils.getText(elt);
                if (!webUri.isEmpty()) continue;
                throw new AppEngineConfigException("web-uri is empty in application.xml web module.");
            }
            if ("context-root".equals(elt.getTagName())) {
                if (contextRoot != null) {
                    throw new AppEngineConfigException("context-root multiply defined in application.xml web module.");
                }
                contextRoot = XmlUtils.getText(elt);
                if (contextRoot.isEmpty()) {
                    throw new AppEngineConfigException("context-root is empty in application.xml web module.");
                }
                if (contextRoots.contains(contextRoot)) {
                    String string2 = contextRoot;
                    throw new AppEngineConfigException(new StringBuilder(36 + String.valueOf(string2).length()).append("context-root value '").append(string2).append("' is not unique.").toString());
                }
                contextRoots.add(contextRoot);
                continue;
            }
            this.reportUnrecognizedTag(elt.getTagName());
        }
        if (null == webUri) {
            throw new AppEngineConfigException("web-uri not defined in application.xml web module.");
        }
        if (null == contextRoot) {
            throw new AppEngineConfigException("context-root not defined in application.xml web module.");
        }
        builder.addWeb(new ApplicationXml.Modules.Web(webUri, contextRoot));
    }

    private void reportUnrecognizedTag(String tag) throws AppEngineConfigException {
        throw new AppEngineConfigException(new StringBuilder(43 + String.valueOf(tag).length()).append("Unrecognized element <").append(tag).append("> in application.xml.").toString());
    }
}

