/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.glob;

import com.google.apphosting.utils.glob.BranchGlob;
import com.google.apphosting.utils.glob.Glob;
import com.google.apphosting.utils.glob.GlobFactory;
import com.google.apphosting.utils.glob.LeafGlob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public class GlobIntersector {
    private final Collection<Glob> inputGlobs = new ArrayList<Glob>();

    public void addGlobs(Glob ... globs) {
        for (Glob glob : globs) {
            this.inputGlobs.add(glob);
        }
    }

    public void addGlob(Glob glob) {
        this.inputGlobs.add(glob);
    }

    public List<Glob> getIntersection() {
        LinkedHashSet<Glob> results = new LinkedHashSet<Glob>();
        this.doIntersect(this.inputGlobs, results);
        ArrayList<Glob> resultList = new ArrayList<Glob>(results);
        this.reorderAndBlendChildren(resultList);
        this.removeExactDuplicates(resultList);
        return resultList;
    }

    private void removeExactDuplicates(Collection<Glob> results) {
        HashSet<String> newResults = new HashSet<String>();
        Iterator<Glob> i = results.iterator();
        while (i.hasNext()) {
            Glob glob = i.next();
            String pattern = glob.getPattern();
            if (newResults.contains(pattern)) {
                i.remove();
                continue;
            }
            newResults.add(pattern);
        }
    }

    private void reorderAndBlendChildren(List<Glob> globs) {
        int size = globs.size();
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                if (globs.get(i).matchesAll(globs.get(j))) {
                    Glob tmp = globs.get(i);
                    globs.set(i, globs.get(j));
                    globs.set(j, tmp);
                }
                if (!globs.get(j).matchesAll(globs.get(i))) continue;
                if (globs.get(i) instanceof LeafGlob) {
                    globs.set(i, GlobFactory.convertToBranch(globs.get(i)));
                }
                ((BranchGlob)globs.get(i)).addChild(globs.get(j));
            }
        }
    }

    private void doIntersect(Collection<Glob> inputGlobs, HashSet<Glob> outputGlobs) {
        if (inputGlobs.size() <= 1) {
            outputGlobs.addAll(inputGlobs);
        } else if (inputGlobs.size() == 2) {
            Iterator<Glob> i = inputGlobs.iterator();
            this.doIntersectTwo(i.next(), i.next(), outputGlobs);
        } else {
            LinkedHashSet<Glob> globs = new LinkedHashSet<Glob>();
            Iterator<Glob> i = inputGlobs.iterator();
            globs.add(i.next());
            while (i.hasNext()) {
                Glob inputGlob = i.next();
                LinkedHashSet<Glob> newGlobs = new LinkedHashSet<Glob>();
                for (Glob glob : globs) {
                    this.doIntersectTwo(inputGlob, glob, newGlobs);
                }
                globs = newGlobs;
            }
            outputGlobs.addAll(globs);
        }
    }

    private void doIntersectTwo(Glob inputGlob1, Glob inputGlob2, HashSet<Glob> outputGlobs) {
        String string;
        String string2;
        int star;
        String pattern2;
        String pattern1 = inputGlob1.getPattern();
        String prefix = this.extractPrefix(pattern1, pattern2 = inputGlob2.getPattern());
        if (prefix != null) {
            int prefixLength = prefix.length();
            if (!prefix.equals(pattern2.substring(0, prefixLength))) {
                outputGlobs.add(inputGlob1);
                outputGlobs.add(inputGlob2);
            } else {
                LinkedHashSet<Glob> newGlobs = new LinkedHashSet<Glob>();
                this.doIntersectTwo(GlobFactory.createChildGlob(pattern1.substring(prefixLength), inputGlob1), GlobFactory.createChildGlob(pattern2.substring(prefixLength), inputGlob2), newGlobs);
                for (Glob newGlob : newGlobs) {
                    String string3 = String.valueOf(prefix);
                    String string4 = String.valueOf(newGlob.getPattern());
                    outputGlobs.add(GlobFactory.createChildGlob(string4.length() != 0 ? string3.concat(string4) : new String(string3), newGlob));
                }
            }
            return;
        }
        String suffix = this.extractSuffix(pattern1, pattern2);
        if (suffix != null) {
            int suffixLength = suffix.length();
            if (!suffix.equals(pattern2.substring(pattern2.length() - suffixLength))) {
                outputGlobs.add(inputGlob1);
                outputGlobs.add(inputGlob2);
            } else {
                LinkedHashSet<Glob> newGlobs = new LinkedHashSet<Glob>();
                this.doIntersectTwo(GlobFactory.createChildGlob(pattern1.substring(0, pattern1.length() - suffixLength), inputGlob1), GlobFactory.createChildGlob(pattern2.substring(0, pattern2.length() - suffixLength), inputGlob2), newGlobs);
                for (Glob newGlob : newGlobs) {
                    String string5 = String.valueOf(newGlob.getPattern());
                    String string6 = String.valueOf(suffix);
                    outputGlobs.add(GlobFactory.createChildGlob(string6.length() != 0 ? string5.concat(string6) : new String(string5), newGlob));
                }
            }
            return;
        }
        if (pattern1.length() > 1 && pattern1.startsWith("*") && pattern1.endsWith("*")) {
            star = pattern2.indexOf("*");
            while (star != -1) {
                string2 = pattern2.substring(0, star);
                string = pattern2.substring(star + 1);
                outputGlobs.add(GlobFactory.createChildGlob(new StringBuilder(String.valueOf(string2).length() + String.valueOf(pattern1).length() + String.valueOf(string).length()).append(string2).append(pattern1).append(string).toString(), inputGlob1, inputGlob2));
                star = pattern2.indexOf("*", star + 1);
            }
        }
        if (pattern2.length() > 1 && pattern2.startsWith("*") && pattern2.endsWith("*")) {
            star = pattern1.indexOf("*");
            while (star != -1) {
                string2 = pattern1.substring(0, star);
                string = pattern1.substring(star + 1);
                outputGlobs.add(GlobFactory.createChildGlob(new StringBuilder(String.valueOf(string2).length() + String.valueOf(pattern2).length() + String.valueOf(string).length()).append(string2).append(pattern2).append(string).toString(), inputGlob1, inputGlob2));
                star = pattern1.indexOf("*", star + 1);
            }
        }
        if (pattern1.length() > 1 && pattern2.length() > 1 && pattern1.endsWith("*") && pattern2.startsWith("*")) {
            String trimmedPattern1 = pattern1.substring(0, pattern1.length() - 1);
            String string7 = String.valueOf(trimmedPattern1);
            String string8 = String.valueOf(pattern2);
            outputGlobs.add(GlobFactory.createChildGlob(string8.length() != 0 ? string7.concat(string8) : new String(string7), inputGlob1, inputGlob2));
            if (inputGlob2.matchesAll(trimmedPattern1)) {
                outputGlobs.add(GlobFactory.createChildGlob(trimmedPattern1, inputGlob1, inputGlob2));
            }
        }
        if (pattern1.length() > 1 && pattern2.length() > 1 && pattern1.startsWith("*") && pattern2.endsWith("*")) {
            String trimmedPattern2 = pattern2.substring(0, pattern2.length() - 1);
            String string9 = String.valueOf(trimmedPattern2);
            String string10 = String.valueOf(pattern1);
            outputGlobs.add(GlobFactory.createChildGlob(string10.length() != 0 ? string9.concat(string10) : new String(string9), inputGlob1, inputGlob2));
            if (inputGlob1.matchesAll(trimmedPattern2)) {
                outputGlobs.add(GlobFactory.createChildGlob(trimmedPattern2, inputGlob1, inputGlob2));
            }
        }
        outputGlobs.add(inputGlob1);
        outputGlobs.add(inputGlob2);
    }

    private String extractPrefix(String pattern1, String pattern2) {
        int firstStar1 = pattern1.indexOf("*");
        int firstStar2 = pattern2.indexOf("*");
        if (firstStar1 != -1 || firstStar2 != -1) {
            int minStar;
            if (firstStar1 == -1) {
                firstStar1 = pattern1.length();
            }
            if (firstStar2 == -1) {
                firstStar2 = pattern2.length();
            }
            if ((minStar = Math.min(firstStar1, firstStar2)) > 0) {
                return pattern1.substring(0, minStar);
            }
        }
        return null;
    }

    private String extractSuffix(String pattern1, String pattern2) {
        int lastStar1 = pattern1.lastIndexOf("*");
        int lastStar2 = pattern2.lastIndexOf("*");
        if (lastStar1 != -1 || lastStar2 != -1) {
            int fromEnd;
            if (lastStar1 == -1) {
                lastStar1 = 0;
            }
            if (lastStar2 == -1) {
                lastStar2 = 0;
            }
            if ((fromEnd = Math.min(pattern1.length() - lastStar1 - 1, pattern2.length() - lastStar2 - 1)) > 0) {
                return pattern1.substring(pattern1.length() - fromEnd);
            }
        }
        return null;
    }
}

