/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.datastore.v1.client;

import com.google.appengine.repackaged.com.google.api.client.util.Preconditions;
import com.google.appengine.repackaged.com.google.datastore.v1.client.Datastore;
import com.google.appengine.repackaged.com.google.datastore.v1.client.DatastoreEmulatorException;
import com.google.appengine.repackaged.com.google.datastore.v1.client.DatastoreEmulatorOptions;
import com.google.appengine.repackaged.com.google.datastore.v1.client.RemoteRpc;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class DatastoreEmulator
extends Datastore {
    private static final int STARTUP_TIMEOUT_SECS = 30;
    private static final String HTTP_POST = "POST";
    private static final String HTTP_GET = "GET";
    private final String host;
    private final DatastoreEmulatorOptions options;
    private volatile State state = State.NEW;
    private File projectDirectory;

    DatastoreEmulator(RemoteRpc rpc, String localHost, DatastoreEmulatorOptions options) {
        super(rpc);
        String string = String.valueOf(localHost);
        this.host = string.length() != 0 ? "http://".concat(string) : new String("http://");
        this.options = options;
    }

    public void clear() throws DatastoreEmulatorException {
        this.sendEmptyRequest("/reset", HTTP_POST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public synchronized void start(String emulatorDir, String projectId, String ... commandLineOptions) throws DatastoreEmulatorException {
        Preconditions.checkNotNull(emulatorDir, "emulatorDir cannot be null");
        Preconditions.checkNotNull(projectId, "projectId cannot be null");
        Preconditions.checkState(this.state == State.NEW, "Cannot call start() more than once.");
        try {
            this.startEmulatorInternal(String.valueOf(emulatorDir).concat("/cloud_datastore_emulator"), projectId, Arrays.asList(commandLineOptions));
            this.state = State.STARTED;
        }
        finally {
            if (this.state != State.STARTED) {
                this.state = State.STOPPED;
            }
        }
    }

    public synchronized void start() throws DatastoreEmulatorException {
        Preconditions.checkState(this.state == State.NEW, "Cannot call start() more than once.");
        try {
            this.startEmulatorInternal(this.options.getCmd(), this.options.getProjectId(), this.options.getCmdLineOptions());
            this.state = State.STARTED;
        }
        finally {
            if (this.state != State.STARTED) {
                this.state = State.STOPPED;
            }
        }
    }

    void startEmulatorInternal(String emulatorCmd, String projectId, List<String> commandLineOptions) throws DatastoreEmulatorException {
        Process emulatorStartProcess;
        this.projectDirectory = this.createProjectDirectory(emulatorCmd, projectId);
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList(emulatorCmd, "start", "--testing"));
        cmd.addAll(commandLineOptions);
        cmd.add(this.projectDirectory.getPath());
        try {
            emulatorStartProcess = this.newEmulatorProcess(cmd).start();
        }
        catch (IOException e) {
            throw new DatastoreEmulatorException("Could not start emulator", e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(this){

            @Override
            public void run() {
                emulatorStartProcess.destroy();
            }
        });
        this.waitForStart();
    }

    private File createProjectDirectory(String emulatorCmd, String projectId) throws DatastoreEmulatorException {
        File projectDirectory;
        try {
            projectDirectory = Files.createTempDirectory("datastore-emulator", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new DatastoreEmulatorException("Could not create temporary project directory", e);
        }
        String[] stringArray = new String[4];
        stringArray[0] = emulatorCmd;
        stringArray[1] = "create";
        String string = String.valueOf(projectId);
        stringArray[2] = string.length() != 0 ? "--project_id=".concat(string) : new String("--project_id=");
        stringArray[3] = projectDirectory.getPath();
        List<String> cmd = Arrays.asList(stringArray);
        try {
            int retCode = this.newEmulatorProcess(cmd).start().waitFor();
            if (retCode != 0) {
                throw new DatastoreEmulatorException(String.format("Could not create project (retcode=%d)", retCode));
            }
        }
        catch (IOException e) {
            throw new DatastoreEmulatorException("Could not create project", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DatastoreEmulatorException("Received an interrupt", e);
        }
        return projectDirectory;
    }

    private ProcessBuilder newEmulatorProcess(List<String> cmd) {
        ProcessBuilder builder = new ProcessBuilder(cmd);
        builder.redirectErrorStream(true);
        builder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        builder.environment().putAll(this.options.getEnvVars());
        return builder;
    }

    public synchronized void stop() throws DatastoreEmulatorException {
        this.stopEmulatorInternal();
        if (this.state != State.STOPPED) {
            this.state = State.STOPPED;
            if (this.projectDirectory != null) {
                try {
                    Process process = new ProcessBuilder("rm", "-r", this.projectDirectory.getAbsolutePath()).start();
                    if (process.waitFor() != 0) {
                        int n = process.exitValue();
                        throw new IOException(new StringBuilder(60).append("Temporary project directory deletion exited with ").append(n).toString());
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException("Could not delete temporary project directory", e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException("Could not delete temporary project directory", e);
                }
            }
        }
    }

    protected void stopEmulatorInternal() throws DatastoreEmulatorException {
        this.sendEmptyRequest("/shutdown", HTTP_POST);
    }

    public synchronized File getProjectDirectory() {
        Preconditions.checkState(this.state == State.STARTED);
        return this.projectDirectory;
    }

    void waitForStart() throws DatastoreEmulatorException {
        long startMillis = System.currentTimeMillis();
        CountDownLatch latch = new CountDownLatch(1);
        try {
            while (true) {
                try {
                    this.sendEmptyRequest("/", HTTP_GET);
                    return;
                }
                catch (DatastoreEmulatorException e) {
                    if (System.currentTimeMillis() <= startMillis + 30000L) continue;
                    throw new DatastoreEmulatorException("Emulator did not start within 30 seconds", e);
                    if (!latch.await(200L, TimeUnit.MILLISECONDS)) continue;
                }
                break;
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new DatastoreEmulatorException("Received an interrupt", ie);
        }
    }

    private void sendEmptyRequest(String path, String httpMethod) throws DatastoreEmulatorException {
        HttpURLConnection connection = null;
        try {
            String string = String.valueOf(this.host);
            String string2 = String.valueOf(path);
            URL url = new URL(string2.length() != 0 ? string.concat(string2) : new String(string));
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod(httpMethod);
            if (HTTP_POST.equals(httpMethod)) {
                connection.setDoOutput(true);
                connection.getOutputStream().close();
            }
            if (connection.getResponseCode() != 200) {
                throw new DatastoreEmulatorException(String.format("%s request to %s returned HTTP status %s", httpMethod, path, connection.getResponseCode()));
            }
        }
        catch (IOException e) {
            throw new DatastoreEmulatorException(String.format("Exception connecting to emulator on %s request to %s", httpMethod, path), e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    static enum State {
        NEW,
        STARTED,
        STOPPED;

    }
}

