/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.base;

import com.google.appengine.repackaged.org.joda.time.Chronology;
import com.google.appengine.repackaged.org.joda.time.DateTimeUtils;
import com.google.appengine.repackaged.org.joda.time.Interval;
import com.google.appengine.repackaged.org.joda.time.Period;
import com.google.appengine.repackaged.org.joda.time.PeriodType;
import com.google.appengine.repackaged.org.joda.time.ReadableDuration;
import com.google.appengine.repackaged.org.joda.time.ReadableInstant;
import com.google.appengine.repackaged.org.joda.time.base.AbstractDuration;
import com.google.appengine.repackaged.org.joda.time.convert.ConverterManager;
import com.google.appengine.repackaged.org.joda.time.convert.DurationConverter;
import com.google.appengine.repackaged.org.joda.time.field.FieldUtils;
import java.io.Serializable;

public abstract class BaseDuration
extends AbstractDuration
implements ReadableDuration,
Serializable {
    private static final long serialVersionUID = 2581698638990L;
    private volatile long iMillis;

    protected BaseDuration(long duration) {
        this.iMillis = duration;
    }

    protected BaseDuration(long startInstant, long endInstant) {
        this.iMillis = FieldUtils.safeAdd(endInstant, -startInstant);
    }

    protected BaseDuration(ReadableInstant start, ReadableInstant end) {
        if (start == end) {
            this.iMillis = 0L;
        } else {
            long startMillis = DateTimeUtils.getInstantMillis(start);
            long endMillis = DateTimeUtils.getInstantMillis(end);
            this.iMillis = FieldUtils.safeAdd(endMillis, -startMillis);
        }
    }

    protected BaseDuration(Object duration) {
        DurationConverter converter = ConverterManager.getInstance().getDurationConverter(duration);
        this.iMillis = converter.getDurationMillis(duration);
    }

    @Override
    public long getMillis() {
        return this.iMillis;
    }

    protected void setMillis(long duration) {
        this.iMillis = duration;
    }

    public Period toPeriod(PeriodType type) {
        return new Period(this.getMillis(), type);
    }

    public Period toPeriod(Chronology chrono) {
        return new Period(this.getMillis(), chrono);
    }

    public Period toPeriod(PeriodType type, Chronology chrono) {
        return new Period(this.getMillis(), type, chrono);
    }

    public Period toPeriodFrom(ReadableInstant startInstant) {
        return new Period(startInstant, this);
    }

    public Period toPeriodFrom(ReadableInstant startInstant, PeriodType type) {
        return new Period(startInstant, this, type);
    }

    public Period toPeriodTo(ReadableInstant endInstant) {
        return new Period(this, endInstant);
    }

    public Period toPeriodTo(ReadableInstant endInstant, PeriodType type) {
        return new Period(this, endInstant, type);
    }

    public Interval toIntervalFrom(ReadableInstant startInstant) {
        return new Interval(startInstant, this);
    }

    public Interval toIntervalTo(ReadableInstant endInstant) {
        return new Interval(this, endInstant);
    }
}

