/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.tools;

import com.google.api.server.spi.ServiceContext;
import com.google.api.server.spi.config.ApiConfig;
import com.google.api.server.spi.config.ApiConfigException;
import com.google.api.server.spi.config.ApiConfigWriter;
import com.google.api.server.spi.config.jsonwriter.JsonConfigWriter;
import com.google.api.server.spi.config.validation.ApiConfigValidator;
import com.google.api.server.spi.tools.AnnotationApiConfigGenerator;
import com.google.api.server.spi.tools.AppEngineUtil;
import com.google.api.server.spi.tools.EndpointsToolAction;
import com.google.appengine.repackaged.com.google.common.io.FileWriteMode;
import com.google.appengine.repackaged.com.google.common.io.Files;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonGenerationException;
import com.google.appengine.repackaged.org.codehaus.jackson.map.JsonMappingException;
import com.google.appengine.tools.util.Option;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class GenApiConfigAction
extends EndpointsToolAction {
    public static final String NAME = "gen-api-config";
    private Option classPathOption = this.makeClassPathOption();
    private Option outputOption = this.makeWarOutputOption();
    private Option warOption = this.makeWarOption();

    public GenApiConfigAction() {
        super(NAME);
        this.setOptions(Arrays.asList(this.classPathOption, this.outputOption, this.warOption));
        this.setShortDescription("Generates API configuration files from service classes");
        this.setHelpDisplayNeeded(false);
    }

    @Override
    public boolean execute() throws JsonGenerationException, JsonMappingException, ClassNotFoundException, IOException, ApiConfigException {
        if (this.getArgs().isEmpty()) {
            return false;
        }
        String warPath = this.getWarPath(this.warOption);
        this.genApiConfig(this.computeClassPath(warPath, this.getClassPath(this.classPathOption)), this.getWarOutputPath(this.outputOption, warPath), warPath, this.getArgs(), true);
        return true;
    }

    public Iterable<String> genApiConfig(URL[] classPath, String outputDirPath, String warPath, List<String> serviceClassNames, boolean outputToDisk) throws ClassNotFoundException, JsonGenerationException, JsonMappingException, IOException, ApiConfigException {
        File outputDir = new File(outputDirPath);
        if (!outputDir.isDirectory()) {
            throw new IllegalArgumentException(String.valueOf(outputDirPath).concat(" is not a directory"));
        }
        URLClassLoader classLoader = new URLClassLoader(classPath, ((Object)((Object)this)).getClass().getClassLoader());
        ApiConfig.Factory configFactory = new ApiConfig.Factory();
        ApiConfigValidator validator = new ApiConfigValidator();
        JsonConfigWriter jsonConfigWriter = new JsonConfigWriter((ClassLoader)classLoader, validator);
        AnnotationApiConfigGenerator generator = new AnnotationApiConfigGenerator((ApiConfigWriter)jsonConfigWriter, classLoader, configFactory);
        Map<String, String> apiConfigs = generator.generateConfig(ServiceContext.create((String)AppEngineUtil.getApplicationId(warPath), (String)"myapi"), GenApiConfigAction.loadClasses(classLoader, serviceClassNames));
        if (outputToDisk) {
            for (Map.Entry<String, String> entry : apiConfigs.entrySet()) {
                String apiConfigFileName = entry.getKey();
                String apiConfigFileContent = entry.getValue();
                String string = String.valueOf(outputDir);
                String apiConfigFilePath = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(apiConfigFileName).length()).append(string).append("/").append(apiConfigFileName).toString();
                Files.asCharSink(new File(apiConfigFilePath), StandardCharsets.UTF_8, new FileWriteMode[0]).write(apiConfigFileContent);
                String string2 = String.valueOf(apiConfigFilePath);
                System.out.println(string2.length() != 0 ? "API configuration written to ".concat(string2) : new String("API configuration written to "));
            }
        }
        return apiConfigs.values();
    }

    private static Class<?>[] loadClasses(ClassLoader classLoader, List<String> classNames) throws ClassNotFoundException {
        Class[] classes = new Class[classNames.size()];
        for (int i = 0; i < classNames.size(); ++i) {
            classes[i] = classLoader.loadClass(classNames.get(i));
        }
        return classes;
    }

    @Override
    public String getUsageString() {
        return "gen-api-config <options> <service class>...";
    }
}

