/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.labs.datastore.overlay;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.QueryResultIterable;
import com.google.appengine.api.datastore.QueryResultIterator;
import com.google.appengine.api.datastore.QueryResultList;
import com.google.appengine.api.labs.datastore.overlay.LazyList;
import com.google.appengine.api.labs.datastore.overlay.NamespacePinnedAsyncDatastoreServiceImpl;
import com.google.appengine.api.labs.datastore.overlay.NamespacePinnedQueryResultIteratorImpl;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.List;

final class NamespacePinnedPreparedQueryImpl
implements PreparedQuery {
    private final NamespacePinnedAsyncDatastoreServiceImpl datastore;
    private final PreparedQuery preparedQuery;

    public NamespacePinnedPreparedQueryImpl(NamespacePinnedAsyncDatastoreServiceImpl datastore, PreparedQuery preparedQuery) {
        this.datastore = Preconditions.checkNotNull(datastore);
        this.preparedQuery = Preconditions.checkNotNull(preparedQuery);
    }

    public List<Entity> asList(FetchOptions fetchOptions) {
        Preconditions.checkNotNull(fetchOptions);
        return this.asQueryResultList(fetchOptions);
    }

    public QueryResultList<Entity> asQueryResultList(FetchOptions fetchOptions) {
        Preconditions.checkNotNull(fetchOptions);
        return new LazyList(this.runQuery(fetchOptions));
    }

    public Iterable<Entity> asIterable(final FetchOptions fetchOptions) {
        Preconditions.checkNotNull(fetchOptions);
        return new Iterable<Entity>(){

            @Override
            public Iterator<Entity> iterator() {
                return NamespacePinnedPreparedQueryImpl.this.asIterator(fetchOptions);
            }
        };
    }

    public Iterable<Entity> asIterable() {
        return this.asIterable(FetchOptions.Builder.withDefaults());
    }

    public QueryResultIterable<Entity> asQueryResultIterable(final FetchOptions fetchOptions) {
        Preconditions.checkNotNull(fetchOptions);
        return new QueryResultIterable<Entity>(){

            public QueryResultIterator<Entity> iterator() {
                return NamespacePinnedPreparedQueryImpl.this.asQueryResultIterator(fetchOptions);
            }
        };
    }

    public QueryResultIterable<Entity> asQueryResultIterable() {
        return this.asQueryResultIterable(FetchOptions.Builder.withDefaults());
    }

    public Iterator<Entity> asIterator(FetchOptions fetchOptions) {
        Preconditions.checkNotNull(fetchOptions);
        return this.asQueryResultIterator(fetchOptions);
    }

    public Iterator<Entity> asIterator() {
        return this.asIterator(FetchOptions.Builder.withDefaults());
    }

    public QueryResultIterator<Entity> asQueryResultIterator(FetchOptions fetchOptions) {
        Preconditions.checkNotNull(fetchOptions);
        return this.runQuery(fetchOptions);
    }

    public QueryResultIterator<Entity> asQueryResultIterator() {
        return this.asQueryResultIterator(FetchOptions.Builder.withDefaults());
    }

    public Entity asSingleEntity() {
        List<Entity> entities = this.asList(FetchOptions.Builder.withLimit((int)2));
        if (entities.isEmpty()) {
            return null;
        }
        if (entities.size() != 1) {
            throw new PreparedQuery.TooManyResultsException();
        }
        return entities.get(0);
    }

    public int countEntities(FetchOptions fetchOptions) {
        Preconditions.checkNotNull(fetchOptions);
        return this.preparedQuery.countEntities(fetchOptions);
    }

    @Deprecated
    public int countEntities() {
        return this.preparedQuery.countEntities();
    }

    private NamespacePinnedQueryResultIteratorImpl runQuery(FetchOptions fetchOptions) {
        Preconditions.checkNotNull(fetchOptions);
        QueryResultIterator iterator = this.preparedQuery.asQueryResultIterator(fetchOptions);
        return new NamespacePinnedQueryResultIteratorImpl(this.datastore, (QueryResultIterator<Entity>)iterator);
    }
}

