/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.InQuerySplitter;
import com.google.appengine.api.datastore.MultiQueryBuilder;
import com.google.appengine.api.datastore.NotEqualQuerySplitter;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QuerySplitComponent;
import com.google.appengine.api.datastore.QuerySplitter;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

final class QuerySplitHelper {
    private static final int MAX_PARALLEL_QUERIES = 30;
    private static final Collection<QuerySplitter> QUERY_SPLITTERS = Collections.synchronizedCollection(Arrays.asList(new NotEqualQuerySplitter(), new InQuerySplitter()));

    private QuerySplitHelper() {
    }

    static List<MultiQueryBuilder> splitQuery(Query query) {
        return QuerySplitHelper.splitQuery(query, QUERY_SPLITTERS);
    }

    static List<MultiQueryBuilder> splitQuery(Query query, Collection<QuerySplitter> splitters) {
        List<MultiQueryBuilder> result;
        if (query.getFilter() == null) {
            result = Collections.singletonList(QuerySplitHelper.splitQuery(query.getFilterPredicates(), query, splitters));
        } else {
            Set<Set<Query.FilterPredicate>> dnf = QuerySplitHelper.getDisjunctiveNormalForm(query.getFilter());
            result = Lists.newArrayListWithCapacity(dnf.size());
            for (Set set : dnf) {
                result.add(QuerySplitHelper.splitQuery(set, query, splitters));
            }
        }
        int totalParallelQueries = 0;
        for (MultiQueryBuilder multiQueryBuilder : result) {
            totalParallelQueries += multiQueryBuilder.getParallelQuerySize();
        }
        Preconditions.checkArgument(totalParallelQueries <= 30, "Splitting the provided query requires that too many subqueries are merged in memory.");
        return result;
    }

    static MultiQueryBuilder splitQuery(Collection<Query.FilterPredicate> filters, Query baseQuery, Collection<QuerySplitter> splitters) {
        LinkedList<Query.FilterPredicate> remainingFilters = Lists.newLinkedList(filters);
        ArrayList<QuerySplitComponent> components = Lists.newArrayList();
        for (QuerySplitter splitter : splitters) {
            components.addAll(splitter.split(remainingFilters, baseQuery.getSortPredicates()));
        }
        return new MultiQueryBuilder(remainingFilters, components, !baseQuery.getSortPredicates().isEmpty());
    }

    static Set<Set<Query.FilterPredicate>> getDisjunctiveNormalForm(Query.Filter filter) {
        if (filter instanceof Query.CompositeFilter) {
            return QuerySplitHelper.getDisjunctiveNormalForm((Query.CompositeFilter)filter);
        }
        if (filter instanceof Query.FilterPredicate) {
            return Collections.singleton(Sets.newLinkedHashSet(ImmutableSet.of((Query.FilterPredicate)filter)));
        }
        String string = String.valueOf(filter.getClass());
        throw new IllegalArgumentException(new StringBuilder(25 + String.valueOf(string).length()).append("Unknown expression type: ").append(string).toString());
    }

    static Set<Set<Query.FilterPredicate>> getDisjunctiveNormalForm(Query.CompositeFilter filter) {
        switch (filter.getOperator()) {
            case AND: {
                return QuerySplitHelper.getDisjunctiveNormalFormAnd(filter.getSubFilters());
            }
            case OR: {
                return QuerySplitHelper.getDisjunctiveNormalFormOr(filter.getSubFilters());
            }
        }
        String string = String.valueOf((Object)filter.getOperator());
        throw new IllegalArgumentException(new StringBuilder(29 + String.valueOf(string).length()).append("Unknown expression operator: ").append(string).toString());
    }

    static Set<Set<Query.FilterPredicate>> getDisjunctiveNormalFormAnd(Collection<Query.Filter> subFilter) {
        LinkedHashSet<Query.FilterPredicate> predicates = Sets.newLinkedHashSetWithExpectedSize(subFilter.size());
        Set<Set<Query.FilterPredicate>> result = null;
        for (Query.Filter filter : subFilter) {
            if (filter instanceof Query.FilterPredicate) {
                predicates.add((Query.FilterPredicate)filter);
                continue;
            }
            if (filter instanceof Query.CompositeFilter) {
                Set<Set<Query.FilterPredicate>> dnf = QuerySplitHelper.getDisjunctiveNormalForm((Query.CompositeFilter)filter);
                if (result == null) {
                    result = dnf;
                    continue;
                }
                LinkedHashSet<Set<Query.FilterPredicate>> combinedDnf = Sets.newLinkedHashSetWithExpectedSize(dnf.size() * result.size());
                for (Set<Query.FilterPredicate> rhs : result) {
                    for (Set<Query.FilterPredicate> lhs : dnf) {
                        LinkedHashSet<Query.FilterPredicate> combined = Sets.newLinkedHashSetWithExpectedSize(rhs.size() + lhs.size());
                        combined.addAll(rhs);
                        combined.addAll(lhs);
                        combinedDnf.add(combined);
                    }
                }
                result = combinedDnf;
                continue;
            }
            String string = String.valueOf(filter.getClass());
            throw new IllegalArgumentException(new StringBuilder(25 + String.valueOf(string).length()).append("Unknown expression type: ").append(string).toString());
        }
        if (result == null) {
            return Collections.singleton(predicates);
        }
        if (!predicates.isEmpty()) {
            for (Set set : result) {
                set.addAll(predicates);
            }
        }
        return result;
    }

    static Set<Set<Query.FilterPredicate>> getDisjunctiveNormalFormOr(Collection<Query.Filter> subFilters) {
        LinkedHashSet<Set<Query.FilterPredicate>> result = Sets.newLinkedHashSetWithExpectedSize(subFilters.size());
        for (Query.Filter subExp : subFilters) {
            result.addAll(QuerySplitHelper.getDisjunctiveNormalForm(subExp));
        }
        return result;
    }
}

