/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.tools.development.ApplicationConfigurationManager;
import com.google.appengine.tools.development.ContainerService;
import com.google.appengine.tools.development.DevAppServer;
import com.google.appengine.tools.development.DevAppServerModulesFilter;
import com.google.appengine.tools.development.LocalEnvironment;
import com.google.appengine.tools.development.LocalServerEnvironment;
import com.google.appengine.tools.development.ModulesFilterHelper;
import com.google.appengine.tools.development.UserCodeClasspathManager;
import com.google.appengine.tools.development.WebAppUserCodeClasspathManager;
import com.google.appengine.tools.info.AppengineSdk;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.ClassPathBuilder;
import com.google.apphosting.utils.config.WebModule;
import com.google.apphosting.utils.config.WebXml;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.Permissions;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractContainerService
implements ContainerService {
    private static final Logger log = Logger.getLogger(AbstractContainerService.class.getName());
    protected static final String AH_URL_RELOAD = "/_ah/reloadwebapp";
    private static final String USER_CODE_CLASSPATH_MANAGER_PROP = "devappserver.userCodeClasspathManager";
    private static final String USER_CODE_CLASSPATH = "devappserver.userCodeClasspathManager.classpath";
    private static final String USER_CODE_REQUIRES_WEB_INF = "devappserver.userCodeClasspathManager.requiresWebInf";
    public static final String PORT_MAPPING_PROVIDER_PROP = "devappserver.portMappingProvider";
    protected ApplicationConfigurationManager.ModuleConfigurationHandle moduleConfigurationHandle;
    protected String devAppServerVersion;
    protected File appDir;
    protected File externalResourceDir;
    protected File webXmlLocation;
    protected String hostName;
    protected String address;
    protected int port;
    protected int instance;
    protected DevAppServer devAppServer;
    protected AppEngineWebXml appEngineWebXml;
    protected WebXml webXml;
    protected String backendName;
    protected int backendInstance;
    protected PortMappingProvider portMappingProvider = new PortMappingProvider(this){

        @Override
        public Map<String, String> getPortMapping() {
            return Collections.emptyMap();
        }
    };
    private CountDownLatch moduleInitLatch;
    protected ApiProxy.Delegate<?> apiProxyDelegate;
    protected UserCodeClasspathManager userCodeClasspathManager;
    protected ModulesFilterHelper modulesFilterHelper;

    @Override
    public final LocalServerEnvironment configure(String devAppServerVersion, final String address, int port, final ApplicationConfigurationManager.ModuleConfigurationHandle moduleConfigurationHandle, File externalResourceDir, Map<String, Object> containerConfigProperties, int instance, DevAppServer devAppServer) {
        this.devAppServerVersion = devAppServerVersion;
        this.moduleConfigurationHandle = moduleConfigurationHandle;
        this.extractFieldsFromWebModule(moduleConfigurationHandle.getModule());
        this.externalResourceDir = externalResourceDir;
        this.address = address;
        this.port = port;
        this.moduleInitLatch = new CountDownLatch(1);
        this.hostName = "localhost";
        this.devAppServer = devAppServer;
        if ("0.0.0.0".equals(address)) {
            try {
                InetAddress localhost = InetAddress.getLocalHost();
                this.hostName = localhost.getHostName();
            }
            catch (UnknownHostException ex) {
                log.logp(Level.WARNING, "com.google.appengine.tools.development.AbstractContainerService", "configure", "Unable to determine hostname - defaulting to localhost.");
            }
        }
        this.userCodeClasspathManager = AbstractContainerService.newUserCodeClasspathProvider(containerConfigProperties);
        this.modulesFilterHelper = (ModulesFilterHelper)containerConfigProperties.get("com.google.appengine.tools.development.modules_filter_helper");
        this.backendName = (String)containerConfigProperties.get("com.google.appengine.backend.id");
        Object rawBackendInstance = containerConfigProperties.get("com.google.appengine.instance.id");
        this.backendInstance = rawBackendInstance == null ? -1 : (Integer)rawBackendInstance;
        PortMappingProvider callersPortMappingProvider = (PortMappingProvider)containerConfigProperties.get(PORT_MAPPING_PROVIDER_PROP);
        if (callersPortMappingProvider == null) {
            log.logp(Level.WARNING, "com.google.appengine.tools.development.AbstractContainerService", "configure", "Null value for containerConfigProperties.get(devappserver.portMappingProvider)");
        } else {
            this.portMappingProvider = callersPortMappingProvider;
        }
        this.instance = instance;
        return new LocalServerEnvironment(){

            @Override
            public File getAppDir() {
                return moduleConfigurationHandle.getModule().getApplicationDirectory();
            }

            @Override
            public String getAddress() {
                return address;
            }

            @Override
            public String getHostName() {
                return AbstractContainerService.this.hostName;
            }

            @Override
            public int getPort() {
                return AbstractContainerService.this.port;
            }

            @Override
            public void waitForServerToStart() throws InterruptedException {
                AbstractContainerService.this.moduleInitLatch.await();
            }

            @Override
            public boolean simulateProductionLatencies() {
                return false;
            }

            @Override
            public boolean enforceApiDeadlines() {
                return !Boolean.getBoolean("com.google.appengine.disable_api_deadlines");
            }
        };
    }

    @Override
    public void setApiProxyDelegate(ApiProxy.Delegate<?> apiProxyDelegate) {
        this.apiProxyDelegate = apiProxyDelegate;
    }

    protected void extractFieldsFromWebModule(WebModule webModule) {
        this.appDir = webModule.getApplicationDirectory();
        this.webXml = webModule.getWebXml();
        this.webXmlLocation = webModule.getWebXmlFile();
        this.appEngineWebXml = webModule.getAppEngineWebXml();
    }

    private static UserCodeClasspathManager newUserCodeClasspathProvider(Map<String, Object> containerConfigProperties) {
        if (containerConfigProperties.containsKey(USER_CODE_CLASSPATH_MANAGER_PROP)) {
            final Map userCodeClasspathManagerProps = (Map)containerConfigProperties.get(USER_CODE_CLASSPATH_MANAGER_PROP);
            return new UserCodeClasspathManager(){

                @Override
                public Collection<URL> getUserCodeClasspath(File root) {
                    return (Collection)userCodeClasspathManagerProps.get(AbstractContainerService.USER_CODE_CLASSPATH);
                }

                @Override
                public boolean requiresWebInf() {
                    return (Boolean)userCodeClasspathManagerProps.get(AbstractContainerService.USER_CODE_REQUIRES_WEB_INF);
                }
            };
        }
        return new WebAppUserCodeClasspathManager();
    }

    @Override
    public final void createConnection() throws Exception {
        this.connectContainer();
    }

    @Override
    public final void startup() throws Exception {
        ApiProxy.Environment prevEnvironment = ApiProxy.getCurrentEnvironment();
        try {
            this.initContext();
            if (this.appEngineWebXml == null) {
                throw new IllegalStateException("initContext failed to initialize appEngineWebXml.");
            }
            this.startContainer();
            this.startHotDeployScanner();
            this.moduleInitLatch.countDown();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)prevEnvironment);
        }
    }

    @Override
    public final void shutdown() throws Exception {
        this.stopHotDeployScanner();
        this.stopContainer();
        this.moduleConfigurationHandle.restoreSystemProperties();
    }

    @Override
    public Map<String, String> getServiceProperties() {
        return ImmutableMap.of("appengine.dev.inbound-services", Joiner.on(",").useForNull("null").join(this.appEngineWebXml.getInboundServices()));
    }

    protected abstract File initContext() throws IOException;

    protected abstract void connectContainer() throws Exception;

    protected abstract void startContainer() throws Exception;

    protected abstract void stopContainer() throws Exception;

    protected abstract void startHotDeployScanner() throws Exception;

    protected abstract void stopHotDeployScanner() throws Exception;

    protected abstract void reloadWebApp() throws Exception;

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public AppEngineWebXml getAppEngineWebXmlConfig() {
        return this.appEngineWebXml;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    protected Permissions getUserPermissions() {
        return this.appEngineWebXml.getUserPermissions();
    }

    protected void installLocalInitializationEnvironment() {
        AbstractContainerService.installLocalInitializationEnvironment(this.appEngineWebXml, this.instance, this.port, this.devAppServer.getPort(), this.backendName, this.backendInstance, this.portMappingProvider.getPortMapping());
    }

    protected boolean isSessionsEnabled() {
        return this.appEngineWebXml.getSessionsEnabled();
    }

    protected URL[] getClassPathForApp(File root) {
        ClassPathBuilder classPathBuilder = new ClassPathBuilder(this.appEngineWebXml.getClassLoaderConfig());
        classPathBuilder.addUrls(this.userCodeClasspathManager.getUserCodeClasspath(root));
        classPathBuilder.addUrls(AppengineSdk.getSdk().getUserJspLibs());
        return AbstractContainerService.getUrls(classPathBuilder);
    }

    private static URL[] getUrls(ClassPathBuilder classPathBuilder) {
        URL[] urls = classPathBuilder.getUrls();
        String message = classPathBuilder.getLogMessage();
        if (!message.isEmpty()) {
            log.logp(Level.WARNING, "com.google.appengine.tools.development.AbstractContainerService", "getUrls", message);
        }
        return urls;
    }

    public static void installLocalInitializationEnvironment(AppEngineWebXml appEngineWebXml, int instance, int port, int defaultModuleMainPort, String backendName, int backendInstance, Map<String, String> portMapping) {
        LocalInitializationEnvironment environment = new LocalInitializationEnvironment(appEngineWebXml.getAppId(), WebModule.getModuleName(appEngineWebXml), appEngineWebXml.getMajorVersionId(), instance, port);
        environment.getAttributes().put("com.google.appengine.runtime.default_version_hostname", new StringBuilder(21).append("localhost:").append(defaultModuleMainPort).toString());
        ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)environment);
        DevAppServerModulesFilter.injectBackendServiceCurrentApiInfo(backendName, backendInstance, portMapping);
    }

    public static interface PortMappingProvider {
        public Map<String, String> getPortMapping();
    }

    public static class LocalInitializationEnvironment
    extends LocalEnvironment {
        public LocalInitializationEnvironment(String appId, String moduleName, String majorVersionId, int instance, int port) {
            super(appId, moduleName, majorVersionId, instance, port, null);
        }

        public String getEmail() {
            return null;
        }

        public boolean isLoggedIn() {
            return false;
        }

        public boolean isAdmin() {
            return false;
        }
    }
}

