/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.jetty9;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.apphosting.utils.config.AppEngineWebXml;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.io.WriterOutputStream;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.resource.Resource;

public class StaticFileUtils {
    private static final String DEFAULT_CACHE_CONTROL_VALUE = "public, max-age=600";
    private final ContextHandler.Context servletContext;
    private static final Pattern EXPIRATION_COMPONENT_PATTERN = Pattern.compile("^(\\d+)([dhms]?)$");

    public StaticFileUtils(ContextHandler.Context servletContext) {
        this.servletContext = servletContext;
    }

    public boolean serveWelcomeFileAsRedirect(String path, boolean included, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (included) {
            return false;
        }
        response.setContentLength(0);
        String q = request.getQueryString();
        if (q != null && q.length() != 0) {
            response.sendRedirect(new StringBuilder(1 + String.valueOf(path).length() + String.valueOf(q).length()).append(path).append("?").append(q).toString());
        } else {
            response.sendRedirect(path);
        }
        return true;
    }

    public boolean serveWelcomeFileAsForward(RequestDispatcher dispatcher, boolean included, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!included && !request.getRequestURI().endsWith("/")) {
            this.redirectToAddSlash(request, response);
            return true;
        }
        request.setAttribute("com.google.appengine.tools.development.isWelcomeFile", (Object)true);
        if (dispatcher != null) {
            if (included) {
                dispatcher.include((ServletRequest)request, (ServletResponse)response);
            } else {
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            }
            return true;
        }
        return false;
    }

    public void redirectToAddSlash(HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuffer buf = request.getRequestURL();
        int param = buf.lastIndexOf(";");
        if (param < 0) {
            buf.append('/');
        } else {
            buf.insert(param, '/');
        }
        String q = request.getQueryString();
        if (q != null && q.length() != 0) {
            buf.append('?');
            buf.append(q);
        }
        response.setContentLength(0);
        response.sendRedirect(response.encodeRedirectURL(buf.toString()));
    }

    public boolean passConditionalHeaders(HttpServletRequest request, HttpServletResponse response, Resource resource) throws IOException {
        if (!request.getMethod().equals(HttpMethod.HEAD.asString())) {
            String ifms = request.getHeader(HttpHeader.IF_MODIFIED_SINCE.asString());
            if (ifms != null) {
                long ifmsl = -1L;
                try {
                    ifmsl = request.getDateHeader(HttpHeader.IF_MODIFIED_SINCE.asString());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (ifmsl != -1L && resource.lastModified() <= ifmsl) {
                    response.reset();
                    response.setStatus(304);
                    response.flushBuffer();
                    return false;
                }
            }
            long date = -1L;
            try {
                date = request.getDateHeader(HttpHeader.IF_UNMODIFIED_SINCE.asString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (date != -1L && resource.lastModified() > date) {
                response.sendError(412);
                return false;
            }
        }
        return true;
    }

    public void sendData(HttpServletRequest request, HttpServletResponse response, boolean include, Resource resource) throws IOException {
        long contentLength = resource.length();
        if (!include) {
            this.writeHeaders(response, request.getRequestURI(), resource, contentLength);
        }
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
        }
        catch (IllegalStateException e) {
            out = new WriterOutputStream((Writer)response.getWriter());
        }
        resource.writeTo((OutputStream)out, 0L, contentLength);
    }

    public void writeHeaders(HttpServletResponse response, String requestPath, Resource resource, long count) {
        String contentType;
        Set<String> headersApplied;
        if (count != -1L) {
            if (count < Integer.MAX_VALUE) {
                response.setContentLength((int)count);
            } else {
                response.setHeader(HttpHeader.CONTENT_LENGTH.asString(), String.valueOf(count));
            }
        }
        if (!(headersApplied = this.addUserStaticHeaders(requestPath, response)).contains("content-type") && (contentType = this.servletContext.getMimeType(resource.getName())) != null) {
            response.setContentType(contentType);
        }
        if (!headersApplied.contains("last-modified")) {
            response.setDateHeader(HttpHeader.LAST_MODIFIED.asString(), resource.lastModified());
        }
        if (!headersApplied.contains(HttpHeader.CACHE_CONTROL.asString().toLowerCase())) {
            response.setHeader(HttpHeader.CACHE_CONTROL.asString(), DEFAULT_CACHE_CONTROL_VALUE);
        }
    }

    @VisibleForTesting
    Set<String> addUserStaticHeaders(String localFilePath, HttpServletResponse response) {
        AppEngineWebXml appEngineWebXml = (AppEngineWebXml)this.servletContext.getAttribute("com.google.appengine.tools.development.appEngineWebXml");
        HashSet<String> headersApplied = new HashSet<String>();
        for (AppEngineWebXml.StaticFileInclude include : appEngineWebXml.getStaticFileIncludes()) {
            Pattern pattern = include.getRegularExpression();
            if (!pattern.matcher(localFilePath).matches()) continue;
            for (Map.Entry<String, String> entry : include.getHttpHeaders().entrySet()) {
                response.addHeader(entry.getKey(), entry.getValue());
                headersApplied.add(entry.getKey().toLowerCase());
            }
            String expirationString = include.getExpiration();
            if (expirationString == null) break;
            StaticFileUtils.addCacheControlHeaders(headersApplied, expirationString, response);
            break;
        }
        return headersApplied;
    }

    private static void addCacheControlHeaders(Set<String> headersApplied, String expiration, HttpServletResponse response) {
        int expirationSeconds = StaticFileUtils.parseExpirationSpecifier(expiration);
        if (expirationSeconds == 0) {
            response.addHeader("Pragma", "no-cache");
            response.addHeader(HttpHeader.CACHE_CONTROL.asString(), "no-cache, must-revalidate");
            response.addDateHeader(HttpHeader.EXPIRES.asString(), 0L);
            headersApplied.add(HttpHeader.CACHE_CONTROL.asString().toLowerCase());
            headersApplied.add(HttpHeader.EXPIRES.asString().toLowerCase());
            headersApplied.add("pragma");
            return;
        }
        if (expirationSeconds > 0) {
            response.addHeader(HttpHeader.CACHE_CONTROL.asString(), new StringBuilder(27).append("public, max-age=").append(expirationSeconds).toString());
            response.addDateHeader(HttpHeader.EXPIRES.asString(), System.currentTimeMillis() + (long)expirationSeconds * 1000L);
            headersApplied.add(HttpHeader.CACHE_CONTROL.asString().toLowerCase());
            headersApplied.add(HttpHeader.EXPIRES.asString().toLowerCase());
            return;
        }
        throw new RuntimeException(new StringBuilder(42).append("expirationSeconds is negative: ").append(expirationSeconds).toString());
    }

    @VisibleForTesting
    static int parseExpirationSpecifier(String expirationSpecifier) {
        if ((expirationSpecifier = expirationSpecifier.trim()).isEmpty()) {
            StaticFileUtils.throwExpirationParseException("", expirationSpecifier);
        }
        String[] components = expirationSpecifier.split("(\\s)+");
        int expirationSeconds = 0;
        for (String componentSpecifier : components) {
            expirationSeconds += StaticFileUtils.parseExpirationSpeciferComponent(componentSpecifier, expirationSpecifier);
        }
        return expirationSeconds;
    }

    private static int parseExpirationSpeciferComponent(String componentSpecifier, String fullSpecifier) {
        Matcher matcher = EXPIRATION_COMPONENT_PATTERN.matcher(componentSpecifier.toLowerCase());
        if (!matcher.matches()) {
            StaticFileUtils.throwExpirationParseException(componentSpecifier, fullSpecifier);
        }
        String numericString = matcher.group(1);
        int numSeconds = StaticFileUtils.parseExpirationInteger(numericString, componentSpecifier, fullSpecifier);
        String unitString = matcher.group(2);
        if (unitString.length() > 0) {
            switch (unitString.charAt(0)) {
                case 'd': {
                    numSeconds *= 86400;
                    break;
                }
                case 'h': {
                    numSeconds *= 3600;
                    break;
                }
                case 'm': {
                    numSeconds *= 60;
                }
            }
        }
        return numSeconds;
    }

    private static int parseExpirationInteger(String intString, String componentSpecifier, String fullSpecifier) {
        int seconds = 0;
        try {
            seconds = Integer.parseInt(intString);
        }
        catch (NumberFormatException e) {
            StaticFileUtils.throwExpirationParseException(componentSpecifier, fullSpecifier);
        }
        if (seconds < 0) {
            StaticFileUtils.throwExpirationParseException(componentSpecifier, fullSpecifier);
        }
        return seconds;
    }

    private static void throwExpirationParseException(String componentSpecifier, String fullSpecifier) {
        throw new IllegalArgumentException(new StringBuilder(61 + String.valueOf(fullSpecifier).length() + String.valueOf(componentSpecifier).length()).append("Unable to parse cache expiration specifier '").append(fullSpecifier).append("' at component '").append(componentSpecifier).append("'").toString());
    }
}

