/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class BackendsXml {
    public static final Set<Option> EMPTY_OPTIONS = Collections.emptySet();
    private final List<Entry> backends = new ArrayList<Entry>();

    public List<Entry> getBackends() {
        return Collections.unmodifiableList(this.backends);
    }

    public void addBackend(Entry entry) {
        this.backends.add(entry);
    }

    public String toString() {
        return this.backends.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BackendsXml) {
            return this.backends.equals(((BackendsXml)obj).backends);
        }
        return false;
    }

    public int hashCode() {
        return this.backends.hashCode();
    }

    public String toYaml() {
        StringBuilder builder = new StringBuilder();
        List<Entry> backends = this.getBackends();
        if (!backends.isEmpty()) {
            builder.append("backends:\n");
            for (Entry entry : backends) {
                String string = entry.getName();
                builder.append(new StringBuilder(9 + String.valueOf(string).length()).append("- name: ").append(string).append("\n").toString());
                if (entry.getInstances() != null) {
                    string = String.valueOf(entry.getInstances());
                    builder.append(new StringBuilder(14 + String.valueOf(string).length()).append("  instances: ").append(string).append("\n").toString());
                }
                if (entry.getInstanceClass() != null) {
                    string = entry.getInstanceClass();
                    builder.append(new StringBuilder(10 + String.valueOf(string).length()).append("  class: ").append(string).append("\n").toString());
                }
                if (entry.getMaxConcurrentRequests() != null) {
                    string = String.valueOf(entry.getMaxConcurrentRequests());
                    builder.append(new StringBuilder(28 + String.valueOf(string).length()).append("  max_concurrent_requests: ").append(string).append("\n").toString());
                }
                ArrayList<String> options = new ArrayList<String>();
                for (Option option : entry.getOptions()) {
                    options.add(option.getYamlValue());
                }
                if (options.isEmpty()) continue;
                String string2 = Joiner.on(", ").useForNull("null").join(options);
                builder.append(new StringBuilder(12 + String.valueOf(string2).length()).append("  options: ").append(string2).append("\n").toString());
            }
        }
        return builder.toString();
    }

    public static enum State {
        START("START"),
        STOP("STOP");

        private final String yamlValue;

        private State(String yamlValue) {
            this.yamlValue = yamlValue;
        }

        public String getYamlValue() {
            return this.yamlValue;
        }

        public static State fromYamlValue(String yamlValue) {
            for (State state : State.values()) {
                if (!state.getYamlValue().equals(yamlValue)) continue;
                return state;
            }
            String string = String.valueOf(yamlValue);
            throw new IllegalArgumentException(string.length() != 0 ? "Unknown value: ".concat(string) : new String("Unknown value: "));
        }
    }

    public static enum Option {
        DYNAMIC("dynamic"),
        FAIL_FAST("failfast"),
        PUBLIC("public");

        private final String yamlValue;

        private Option(String yamlValue) {
            this.yamlValue = yamlValue;
        }

        public String getYamlValue() {
            return this.yamlValue;
        }

        public static Option fromYamlValue(String yamlValue) {
            for (Option option : Option.values()) {
                if (!option.getYamlValue().equals(yamlValue)) continue;
                return option;
            }
            String string = String.valueOf(yamlValue);
            throw new IllegalArgumentException(string.length() != 0 ? "Unknown value: ".concat(string) : new String("Unknown value: "));
        }
    }

    public static class Entry {
        private final String name;
        private final Integer instances;
        private final String instanceClass;
        private final Integer maxConcurrentRequests;
        private final Set<Option> options;
        private final State state;

        public Entry(String name, Integer instances, String instanceClass, Integer maxConcurrentRequests, Set<Option> options, State state) {
            this.name = name;
            this.instances = instances;
            this.instanceClass = instanceClass;
            this.maxConcurrentRequests = maxConcurrentRequests;
            if (options == null) {
                throw new NullPointerException("options must be specified");
            }
            this.options = options;
            this.state = state;
        }

        public String getName() {
            return this.name;
        }

        public Integer getInstances() {
            return this.instances;
        }

        public String getInstanceClass() {
            return this.instanceClass;
        }

        public Integer getMaxConcurrentRequests() {
            return this.maxConcurrentRequests;
        }

        public Set<Option> getOptions() {
            return this.options;
        }

        public boolean isFailFast() {
            return this.options.contains((Object)Option.FAIL_FAST);
        }

        public boolean isDynamic() {
            return this.options.contains((Object)Option.DYNAMIC);
        }

        public boolean isPublic() {
            return this.options.contains((Object)Option.PUBLIC);
        }

        public State getState() {
            return this.state;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.name.hashCode();
            result = 31 * result + (this.instances == null ? 0 : this.instances.hashCode());
            result = 31 * result + (this.instanceClass == null ? 0 : this.instanceClass.hashCode());
            result = 31 * result + (this.maxConcurrentRequests == null ? 0 : this.maxConcurrentRequests.hashCode());
            result = 31 * result + (this.options == null ? 0 : this.options.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)obj;
            if (!this.name.equals(entry.name)) {
                return false;
            }
            if (this.instances == null ? entry.instances != null : !this.instances.equals(entry.instances)) {
                return false;
            }
            if (this.instanceClass == null ? entry.instanceClass != null : !this.instanceClass.equals(entry.instanceClass)) {
                return false;
            }
            if (this.maxConcurrentRequests == null ? entry.maxConcurrentRequests != null : !this.maxConcurrentRequests.equals(entry.maxConcurrentRequests)) {
                return false;
            }
            return !(this.options == null ? entry.options != null : !this.options.equals(entry.options));
        }

        public String toString() {
            String string;
            StringBuilder builder = new StringBuilder();
            builder.append("Backend: ");
            builder.append(this.name);
            if (this.instances != null) {
                string = String.valueOf(this.instances);
                builder.append(new StringBuilder(14 + String.valueOf(string).length()).append(", instances = ").append(string).toString());
            }
            if (this.instanceClass != null) {
                String string2 = String.valueOf(this.instanceClass);
                builder.append(string2.length() != 0 ? ", instanceClass = ".concat(string2) : new String(", instanceClass = "));
            }
            if (this.maxConcurrentRequests != null) {
                string = String.valueOf(this.maxConcurrentRequests);
                builder.append(new StringBuilder(26 + String.valueOf(string).length()).append(", maxConcurrentRequests = ").append(string).toString());
            }
            if (this.options != null) {
                string = String.valueOf(this.options);
                builder.append(new StringBuilder(12 + String.valueOf(string).length()).append(", options = ").append(string).toString());
            }
            if (this.state != null) {
                string = String.valueOf((Object)this.state);
                builder.append(new StringBuilder(10 + String.valueOf(string).length()).append(", state = ").append(string).toString());
            }
            return builder.toString();
        }
    }
}

