package javax.persistence.criteria;

public interface SelectItem extends OrderByItem
{
    /**
     * Return an OrderByItem referencing the SelectItem and
     * specifying ascending ordering.
     * The SelectItem must correspond to an orderable value.
     * @return order-by item
     */
    OrderByItem asc();

    /**
     * Return an OrderByItem referencing the SelectItem and
     * specifying descending ordering.
     * The SelectItem must correspond to an orderable value.
     * @return order-by item
     */
    OrderByItem desc();
}