package com.google.appengine.api.modules;

import com.google.appengine.spi.FactoryProvider;
import com.google.appengine.spi.ServiceProvider;
import com.google.auto.service.AutoService;

/**
 * Google App Engine's {@link FactoryProvider} for {@link IModulesServiceFactory}.
 *
 */
@AutoService(FactoryProvider.class)
@ServiceProvider(precedence = Integer.MIN_VALUE)
public final class IModulesServiceFactoryProvider extends FactoryProvider<IModulesServiceFactory> {
  private final IModulesServiceFactory instance = new ModulesServiceFactoryImpl();

  public IModulesServiceFactoryProvider() {
    super(IModulesServiceFactory.class);
  }

  @Override
  protected IModulesServiceFactory getFactoryInstance() {
    return instance;
  }
}
