// Copyright 2012 Google Inc. All rights reserved.
package com.google.appengine.api.oauth;

import com.google.appengine.spi.FactoryProvider;
import com.google.appengine.spi.ServiceProvider;
import com.google.auto.service.AutoService;

/**
 * Factory provider for {@link IOAuthServiceFactory}.
 *
 * <p><b>Note:</b> This class is not intended for end users.
 *
 */
@AutoService(FactoryProvider.class)
@ServiceProvider(precedence = Integer.MIN_VALUE)
public final class IOAuthServiceFactoryProvider extends FactoryProvider<IOAuthServiceFactory> {

  private final OAuthServiceFactoryImpl implementation = new OAuthServiceFactoryImpl();

  public IOAuthServiceFactoryProvider() {
    super(IOAuthServiceFactory.class);
  }

  @Override
  protected IOAuthServiceFactory getFactoryInstance() {
    return implementation;
  }

}
