/**********************************************************************
Copyright (c) 2008 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.query;

/**
 * JPQL query helper class providing key information about the language etc.
 */
public class JPQLQueryHelper
{
    /** Keywords used in single-string JPQL. Uppercase variants specified here, but JPQL allows case-insensitive. */
    public static final String[] SINGLE_STRING_KEYWORDS = {
        "SELECT", "UPDATE", "DELETE", "FROM", "WHERE", "GROUP BY", "HAVING", "ORDER BY"
        };

    /** List of identifier names not allowed by JPQL. */
    public static final String[] RESERVED_IDENTIFIERS = {
        "SELECT", "FROM", "WHERE", "UPDATE", "DELETE", "JOIN", "OUTER", "INNER", "LEFT", "GROUP", "BY", 
        "HAVING", "FETCH", "DISTINCT", "OBJECT", "NULL", "TRUE", "FALSE", "NOT", "AND", "OR", "BETWEEN", 
        "LIKE", "IN", "AS", "UNKNOWN", "EMPTY", "MEMBER", "OF", "IS", "AVG", "MAX", "MIN", "SUM", "COUNT", 
        "ORDER", "ASC", "DESC", "MOD", "UPPER", "LOWER", "TRIM", "POSITION", "CHARACTER_LENGTH", 
        "CHAR_LENGTH", "BIT_LENGTH", "CURRENT_TIME", "CURRENT_DATE", "CURRENT_TIMESTAMP", "NEW", "EXISTS", 
        "ALL", "ANY", "SOME"
    };

    /**
     * Convenience method returning if the supplied name is a keyword for this query language.
     * @param name Name to check
     * @return Whether it is a keyword
     */
    public static boolean isKeyword(String name)
    {
        for (int i=0;i<SINGLE_STRING_KEYWORDS.length;i++)
        {
            // JPQL is case-insensitive
            if (name.equalsIgnoreCase(SINGLE_STRING_KEYWORDS[i]))
            {
                return true;
            }
        }
        return false;
    }

    /**
     * Convenience method returning if the supplied name is a reserved identifier for this query language.
     * @param name Name to check
     * @return Whether it is a reserved identifier
     */
    public static boolean isReservedIdentifier(String name)
    {
        for (int i=0;i<RESERVED_IDENTIFIERS.length;i++)
        {
            // JPQL is case-insensitive
            if (name.equalsIgnoreCase(RESERVED_IDENTIFIERS[i]))
            {
                return true;
            }
        }
        return false;
    }
}