/*
 * Decompiled with CFR 0.152.
 */
package http.utils.multipartrequest;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;

public class TempFile {
    private static final Object tmpFileLock = new Object();
    private static int counter = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createTempFile(String prefix, String suffix, File directory) throws IOException {
        if (prefix == null) {
            throw new NullPointerException();
        }
        if (prefix.length() < 3) {
            throw new IllegalArgumentException("Prefix string too short");
        }
        String extension = suffix == null ? "tmp" : suffix;
        Object object = tmpFileLock;
        synchronized (object) {
            File f;
            SecurityManager sm = System.getSecurityManager();
            while (true) {
                if ((f = TempFile.generateFile(prefix, extension, directory)).exists()) {
                    continue;
                }
                try {
                    FileWriter writer = new FileWriter(f);
                    writer.close();
                }
                catch (Exception e) {
                    continue;
                }
                break;
            }
            return f;
        }
    }

    private static File generateFile(String prefix, String extension, File dir) throws IOException {
        if (counter == -1) {
            counter = new Random().nextInt() & 0xFFFF;
        }
        return new File(dir, prefix + Integer.toString(++counter) + "." + extension);
    }
}

