/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.servlet;

import ccl.util.Util;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

/**
 * Sometimes a slightly changed HttpServletRequest
 * object is needed with just new parameter
 * values. An instance of this class encapsulates
 * an http request and forwards all messages to this
 * object except for changed parameters.<p />
 * 
 * This class adds setParameter to a standard http request.
 * 
 * @author  Chr. Clemens Lee
 * @version $Id: ChangedRequest.java,v 1.6 2003/05/01 16:44:01 clemens Exp clemens $
 */
public class ChangedRequest implements HttpServletRequest 
{
    private HttpServletRequest _request      = null;

    private Hashtable          _htParameters = null;

    public ChangedRequest( HttpServletRequest request )
    {
        super();

        _request = request;

        _htParameters = new Hashtable();
    }

    /**
     * Lets you change the value of a parameter or add a new
     * one.
     */
    public void putParameter( String name, String value ) 
{
        _htParameters.put( name, new String[] { value } );
    }

    /**
     * Lets you change the values of a parameter or add a new
     * one.
     */
    public void putParameterValues( String name, String[] values ) 
{
        _htParameters.put( name, values );
    }

    /**
     * Returns a new or changed parameter if existing,
     * otherwise this method returns the original parameter.
     */
    public String getParameter( String name )
    {
        String[] values = (String[])_htParameters.get( name );
        if ( values == null )
        {
            return _request.getParameter( name );
        }
        
        return values[ 0 ];
    }

    /**
     * Returns new or changed parameter values if existing,
     * otherwise this method returns the originals.
     */
    public String[] getParameterValues( String name )
    {
        String[] values = (String[])_htParameters.get( name );
        if ( values == null )
        {
            return _request.getParameterValues( name );
        }
        
        return values;
    }

    /**
     * Returns new or changed parameter names if existing plus
     * the rest of the unchanged names.
     */
    public java.util.Enumeration getParameterNames()
    {
        Vector vNames = Util.toVector( _request.getParameterNames() );
        Enumeration newNames = _htParameters.keys();
        while( newNames.hasMoreElements() )
        {
            String sNextName = (String)newNames.nextElement();
            if ( !vNames.contains( sNextName ) )
            {
                vNames.addElement( sNextName );
            }
        }

        return vNames.elements();        
    }


    //
    // forwards to encapsulated request object ---------------
    //


    /**
     * Forwards message to original request object.
     */
    public java.lang.Object getAttribute(java.lang.String s) 
{ return _request.getAttribute(s); }

    /**
     * Forwards message to original request object.
     */
    public java.util.Enumeration getAttributeNames() 
{ return _request.getAttributeNames(); }

    /**
     * Forwards message to original request object.
     */
    public java.lang.String getCharacterEncoding() 
{ return _request.getCharacterEncoding(); }

    /**
     * Forwards message to original request object.
     */
    public int getContentLength() 
{ return _request.getContentLength(); }

    /**
     * Forwards message to original request object.
     */
    public java.lang.String getContentType() 
{ return _request.getContentType(); }

    /**
     * Forwards message to original request object.
     */
    public javax.servlet.ServletInputStream getInputStream() throws java.io.IOException 
{ return _request.getInputStream(); }

    /**
     * Forwards message to original request object.
     */
    public java.util.Locale getLocale() 
{ return _request.getLocale(); }

    /**
     * Forwards message to original request object.
     */
    public java.util.Enumeration getLocales() 
{ return _request.getLocales(); }

    /**
     * Forwards message to original request object.
     */
    public java.lang.String getProtocol() 
{ return _request.getProtocol(); }

    /**
     * Forwards message to original request object.
     */
    public java.io.BufferedReader getReader() throws java.io.IOException 
{ return _request.getReader(); }

    /**
     * Forwards message to original request object.
     */
    public java.lang.String getRealPath(java.lang.String s) 
{ return _request.getRealPath(s); }

    /**
     * Forwards message to original request object.
     */
    public java.lang.String getRemoteAddr() 
{ return _request.getRemoteAddr(); }

    /**
     * Forwards message to original request object.
     */
    public java.lang.String getRemoteHost() 
{ return _request.getRemoteHost(); }

    /**
     * Forwards message to original request object.
     */
    public javax.servlet.RequestDispatcher getRequestDispatcher(java.lang.String s) 
{ return _request.getRequestDispatcher(s); }

    /**
     * Forwards message to original request object.
     */
    public java.lang.String getScheme() 
{ return _request.getScheme(); }

    /**
     * Forwards message to original request object.
     */
    public java.lang.String getServerName() 
{ return _request.getServerName(); }

    /**
     * Forwards message to original request object.
     */
    public int getServerPort() 
{ return _request.getServerPort(); }

    /**
     * Forwards message to original request object.
     */
    public boolean isSecure() 
{ return _request.isSecure(); }

    /**
     * Forwards message to original request object.
     */
    public void removeAttribute(java.lang.String s) 
{ _request.removeAttribute(s); }

    /**
     * Forwards message to original request object.
     */
    public void setAttribute(java.lang.String s, java.lang.Object o) 
{ _request.setAttribute(s, o); }

    /**
     * Forwards message to original request object.
     */
    public java.lang.String getAuthType() 
{ return _request.getAuthType(); }

    /**
     * Forwards message to original request object.
     */
    public java.lang.String getContextPath() 
{ return _request.getContextPath(); }

    /**
     * Forwards message to original request object.
     */
    public javax.servlet.http.Cookie[] getCookies() 
{ return _request.getCookies(); }

    /**
     * Forwards message to original request object.
     */
    public long getDateHeader(java.lang.String s) 
{ return _request.getDateHeader(s); }

    /**
     * Forwards message to original request object.
     */
    public java.lang.String getHeader(java.lang.String s) 
{ return _request.getHeader(s); }

    /**
     * Forwards message to original request object.
     */
    public java.util.Enumeration getHeaderNames() 
{ return _request.getHeaderNames(); }

    /**
     * Forwards message to original request object.
     */
    public java.util.Enumeration getHeaders(java.lang.String s) 
{ return _request.getHeaders(s); }

    /**
     * Forwards message to original request object.
     */
    public int getIntHeader(java.lang.String s) 
{ return _request.getIntHeader(s); }

    /**
     * Forwards message to original request object.
     */
    public java.lang.String getMethod() 
{ return _request.getMethod(); }

    /**
     * Forwards message to original request object.
     */
    public java.lang.String getPathInfo() 
{ return _request.getPathInfo(); }

    /**
     * Forwards message to original request object.
     */
    public java.lang.String getPathTranslated() 
{ return _request.getPathTranslated(); }

    /**
     * Forwards message to original request object.
     */
    public java.lang.String getQueryString() 
{ return _request.getQueryString(); }

    /**
     * Forwards message to original request object.
     */
    public java.lang.String getRemoteUser() 
{ return _request.getRemoteUser(); }

    /**
     * Forwards message to original request object.
     */
    public java.lang.String getRequestURI() 
{ return _request.getRequestURI(); }

    /**
     * Forwards message to original request object.
     */
    public java.lang.String getRequestedSessionId() 
{ return _request.getRequestedSessionId(); }

    /**
     * Forwards message to original request object.
     */
    public java.lang.String getServletPath() 
{ return _request.getServletPath(); }

    /**
     * Forwards message to original request object.
     */
    public javax.servlet.http.HttpSession getSession() 
{ return _request.getSession(); }

    /**
     * Forwards message to original request object.
     */
    public javax.servlet.http.HttpSession getSession(boolean b) 
{ return _request.getSession(b); }

    /**
     * Forwards message to original request object.
     */
    public java.security.Principal getUserPrincipal() 
{ return _request.getUserPrincipal(); }

    /**
     * Forwards message to original request object.
     */
    public boolean isRequestedSessionIdFromCookie() 
{ return _request.isRequestedSessionIdFromCookie(); }

    /**
     * Forwards message to original request object.
     */
    public boolean isRequestedSessionIdFromURL() 
{ return _request.isRequestedSessionIdFromURL(); }

    /**
     * Forwards message to original request object.
     */
    public boolean isRequestedSessionIdFromUrl() 
{ return _request.isRequestedSessionIdFromUrl(); }

    /**
     * Forwards message to original request object.
     */
    public boolean isRequestedSessionIdValid() 
{ return _request.isRequestedSessionIdValid(); }

    /**
     * Forwards message to original request object.
     */
    public boolean isUserInRole(java.lang.String s) 
{ return _request.isUserInRole(s); }

    //
    // Latest methods and api additions.
    //

    /**
     * Forwards message to original request object.
     */
    public void setCharacterEncoding( String env )
        throws java.io.UnsupportedEncodingException
    {
        _request.setCharacterEncoding( env );
    }

    /**
     * Forwards message to original request object.
     */
    public java.util.Map getParameterMap()
    {
        return _request.getParameterMap();
    }

    /**
     * Forwards message to original request object.
     */
    public java.lang.StringBuffer getRequestURL()
    {
        return _request.getRequestURL();
    }
}
