/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.MenuElement;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

/**
 * Compiles only with jdk 1.2.
 *
 * @author  Chr. Clemens Lee
 * @version $Id: ComponentHierachyFrame.java,v 1.6 2002/10/06 16:41:29 clemens Exp clemens $
 */
public class ComponentHierachyFrame extends JFrame 
{
    private JButton _btnUpdate = null;
    private JButton _btnClose = null;
    private JTree _pTree = null;

    private DefaultMutableTreeNode _add( DefaultTreeModel pDefaultTreeModel_,
                                         DefaultMutableTreeNode tnParent_,
                                         Component pComponent_,
                                         int index_ )
    {
        DefaultMutableTreeNode tnComponent = new DefaultMutableTreeNode
               ( pComponent_.toString() );
        pDefaultTreeModel_.insertNodeInto( tnComponent, tnParent_, index_ );
        TreePath pTreePath = new TreePath
               ( pDefaultTreeModel_.getPathToRoot( tnComponent ) );
        _pTree.expandPath( pTreePath );

        // now add components children
        if ( pComponent_ instanceof MenuElement ) 
        {
            MenuElement[] apMenuElement = ((MenuElement) pComponent_)
                   .getSubElements();
            for( int child = 0; child < apMenuElement.length; child++ ) 
            {
                _add( pDefaultTreeModel_, 
                      tnComponent, 
                      (Component) apMenuElement[ child ],
                      child );
            }
        } 
        else if ( pComponent_ instanceof Container ) 
        {
            Container pContainer = (Container) pComponent_;

            Component[] apComponent = pContainer.getComponents();
            for( int child = 0; child < apComponent.length; child++ ) 
            {
                _add( pDefaultTreeModel_, 
                      tnComponent, 
                      apComponent[ child ],
                      child );
            }
        } 

        return tnComponent;
    }

    private void _update() 
    {
        SwingUtil.invokeLaterIfNecessary( new Runnable() {
            public void run() 
            {
                DefaultMutableTreeNode tnRoot = new DefaultMutableTreeNode
                       ( "All frames and their owned windows" );
                // new model
                DefaultTreeModel pDefaultTreeModel = new DefaultTreeModel
                       ( tnRoot );
                _pTree.setModel( pDefaultTreeModel );
                
                // get all frames
                Frame[] apFrame = Frame.getFrames();
                
                int index = 0;
                for( int frame = 0; frame < apFrame.length; frame++ ) 
                {
                    Frame frmNext = apFrame[ frame ];
                    if ( frmNext == ComponentHierachyFrame.this ) 
                    {
                        continue;
                    }
                    
                    _add( pDefaultTreeModel, tnRoot, frmNext, index );
                    index++;
                    
                    // for each frame get owned windows
                    Window[] apWindow = frmNext.getOwnedWindows();
                    for( int window = 0; window < apWindow.length; window++ ) 
                    {
                        _add( pDefaultTreeModel
                              , tnRoot
                              , apWindow[ window]
                              , index );
                        index++;
                    }
                }
                // open up the whole tree
            }
        } );
    }

    public ComponentHierachyFrame() 
    {
        super( "Component Hierachy Viewer" );

        _btnUpdate = new JButton( "Update" );
        _btnClose = new JButton( "Close" );

        _btnUpdate.addActionListener( new ActionListener() {
            public void actionPerformed( ActionEvent pActionEvent_ ) 
            {
                _update();
            }
        } );
        _btnClose.addActionListener( new ActionListener() {
            public void actionPerformed( ActionEvent pActionEvent_ ) 
            {
                ComponentHierachyFrame.this.dispose();
            }
        } );

        DefaultMutableTreeNode tnRoot = new DefaultMutableTreeNode( "JFrame" );
        DefaultTreeModel pDefaultTreeModel = new DefaultTreeModel( tnRoot );
        _pTree = new JTree( pDefaultTreeModel );

        JScrollPane pScrollPane = new JScrollPane( _pTree );
        pScrollPane.setBorder( SwingUtil.createCCLBorder() );

        getContentPane().setLayout( new BorderLayout() );

        getContentPane().add( _btnUpdate, BorderLayout.NORTH );
        getContentPane().add( pScrollPane, BorderLayout.CENTER );
        getContentPane().add( _btnClose, BorderLayout.SOUTH );

        SwingUtil.maximizeWindow( this );
    }

    private UpdateThread _pThread = null;

    private class UpdateThread extends Thread 
    {
        private boolean _bStop = false;
        public UpdateThread() 
        {
            super();
            _bStop = false;
        }

        public void run() 
        {
            while( _bStop == false ) 
            {
                try 
                {
                    sleep( 10 * 1000 );
                    _update();
                }
                catch( Exception pException ) 
                {
                }
            }
        }

        public void stopIt() 
        {
            _bStop = true;
            interrupt();
        }
    }

    public void setVisible( boolean bVisible_ ) 
    {
        if ( bVisible_ ) 
        {
            _pThread = new UpdateThread();
            //_pThread.start();
        }
        else 
        {
            if ( _pThread != null ) 
            {
                _pThread.stopIt();
                try 
                {
                    _pThread.join();
                }
                catch( Exception pException ) 
                {
                }
            }
        }
        
        super.setVisible( bVisible_ );
    }
}
