/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.swing;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;

/**
 * The model for the DoubleList component. This model actually represents a tree
 * with a root that is not used for anything and than a depth of 2.
 *
 * @author  Chr. Clemens Lee
 * @version $Id: DoubleListModel.java,v 1.4 2002/10/06 16:41:31 clemens Exp clemens $
 */
public class DoubleListModel 
{
    private int _indexFirst = -1;
    /** Used to store the first list. */
    private DefaultListModel _dlmFirst = null;
    /** Contains a list of DefaultListModel elements for the second level. */
    private Vector _vSubLists = null;

    public DoubleListModel( Vector vFirstList_, 
                            Vector vSecondList_ )
    {
        super();

        set( vFirstList_, vSecondList_ );
    }

    /**
     * The first vector contains the elements for the first model.
     * The second vector contains for each element from the first vector
     * a vector with elements that belong to the element from the first vector.
     */
    public void set( Vector vFirst_, Vector vSecond_ ) 
{
        _dlmFirst = new DefaultListModel();
        _vSubLists = new Vector();
        Enumeration eFirstList = vFirst_.elements();
        int indexSecondList = 0;
        while( eFirstList.hasMoreElements() ) 
{
            _dlmFirst.addElement( eFirstList.nextElement() );
            
            Vector vNextSubList = (Vector)vSecond_.
                   elementAt( indexSecondList );
            indexSecondList++;
            
            DefaultListModel dlmNextSub = new DefaultListModel();
            Enumeration eNextSubList = vNextSubList.elements();
            while( eNextSubList.hasMoreElements() ) 
{
                dlmNextSub.addElement( eNextSubList.nextElement() );
            }

            _vSubLists.addElement( dlmNextSub );
        }     
    }

    public DefaultListModel getFirstModel() 
{
        return _dlmFirst;
    }

    public Vector getSecondVector() 
{
        return _vSubLists;
    }

    public DefaultListModel getSecondModel() 
{
        return (DefaultListModel)getSecondModel
               ( _indexFirst );
    }

    public ListModel getSecondModel( int index_ ) 
{
        _indexFirst = index_;
        if ( _indexFirst < 0 || _dlmFirst.getSize() <= _indexFirst ) 
{
            throw new IllegalArgumentException
                   ( "Index " +
                     _indexFirst + " out of range [0 .. " +
                     _dlmFirst.getSize() + "[!" );
        }
        DefaultListModel dlmRetVal = 
               (DefaultListModel)_vSubLists.elementAt
               ( _indexFirst );

        return dlmRetVal;
    }

    public void insertSecondElementAt( DefaultListModel pDefaultListModel_,
                                       int index_ )
    {
        _vSubLists.insertElementAt( pDefaultListModel_, 
                                    index_ );
    }

    public void removeSecondElementAt( int index_ ) 
{
        _vSubLists.removeElementAt( index_ );
    }

    /**
     * Adds a new element into the first model with an empty list for the
     * second model.
     */
    public void addFirstElement( Object pObject_ ) 
    {
        // store data
        _dlmFirst.addElement( pObject_ );
        _vSubLists.addElement( new DefaultListModel() );
    }
}
