// Copyright (c) Microsoft Corporation 2005-2007.
// This sample code is provided "as is" without warranty of any kind. 
// We disclaim all warranties, either express or implied, including the 
// warranties of merchantability and fitness for a particular purpose. 
//

open System
open System.Collections.Generic
open System.Windows.Forms
open System.IO
open Sample.Support

/// The main entry point for the application.
[<EntryPoint; STAThread>]
let main(argv) = 
    let harnesses = getSamples() in 
    match argv with 
    | [| _; "/runall" |] -> 
        harnesses |> List.iter (fun (_,samples) -> samples |> List.iter (fun s -> s.Run()))
    | _ -> 
        Application.EnableVisualStyles();
        let form = new Display.SampleForm("F# LINQ Project Sample Query Explorer", harnesses) in 
        ignore(form.ShowDialog())

