(* (c) Microsoft Corporation. All rights reserved *)

(*F#
/// Printer for the abstract syntax.
module Microsoft.Research.AbstractIL.AsciiWriter 
open Microsoft.Research.AbstractIL 
open Microsoft.Research.AbstractIL.Internal 
module Il = Microsoft.Research.AbstractIL.IL 
module Ilx = Microsoft.Research.AbstractIL.Extensions.ILX.Types 
F#*)  
open Ilx
open Il

(** Save in .il format *)
val print_module: (*F# filename: F#*) string -> (*F# input: F#*) Il.modul -> unit

val output_sqstring: out_channel -> string -> unit
val output_qstring: out_channel -> string -> unit
val output_typ: out_channel -> typ -> unit
val output_ldtoken_info: out_channel -> ldtoken_info -> unit
val output_tspec: out_channel -> type_spec -> unit
val output_scoref: out_channel -> scope_ref -> unit
val output_tref: out_channel -> type_ref -> unit
val output_gparam: out_channel -> genparam -> unit
val output_gactual: out_channel -> genactual -> unit
val output_gparams: out_channel -> genparams -> unit
val output_callconv: out_channel -> callconv -> unit
val output_callsig: out_channel -> callsig -> unit
val output_mspec: out_channel -> method_spec -> unit
val output_mref: out_channel -> method_ref -> unit
val output_gactuals: out_channel -> genactuals -> unit
val output_fspec: out_channel -> field_spec -> unit
val output_member_access: out_channel -> member_access -> unit
val output_fdef:  out_channel -> field_def -> unit
val output_byte: out_channel -> int -> unit
val output_bytes: out_channel -> bytes -> unit
val output_basic_type: out_channel -> basic_type -> unit
val output_alignment: out_channel -> alignment -> unit
val output_volatility: out_channel -> volatility -> unit
val output_tailness: out_channel -> tailness -> unit
val output_instr: out_channel -> instr -> unit
val output_ilmbody: out_channel -> il_method_body -> unit
val output_custom_attr: out_channel -> custom_attr -> unit
val output_tdef: out_channel -> type_def -> unit
val output_module: out_channel -> modul -> unit
val output_assref: out_channel -> assembly_ref -> unit
val output_modref: out_channel -> modul_ref -> unit
val output_module_manifest: out_channel -> modul -> unit
val output_module_fragment: out_channel -> modul -> refs
val output_module_refs: out_channel -> refs -> unit
val output_sig_of_mdef: out_channel -> method_def -> unit
val output_code_label: out_channel -> code_label -> unit
val string_of_instr: instr -> string 

(* -------------------------------------------------------------------- 
 * IL Printing flags
 * First flags for doing some last-minute micro code transformations as code
 * is printed.
 * -------------------------------------------------------------------- *)

val print_tailcall : bool ref
val tailcall_via_ldftn : bool ref
val call_via_ldftn : bool ref
