// (c) Microsoft Corporation 2005-2007. 

#light

namespace Microsoft.FSharp.Math

open Microsoft.FSharp.Core
open Microsoft.FSharp.Collections
open Microsoft.FSharp.Math

/// This module contains notation related to matrices and vectors
module Notation =

      /// Create a complex number x+ij using rectangular coordinates
    val complex : r:float -> i:float -> complex

    /// The type of complex numbers
    type complex = Complex
    /// The type of floating point matrices
    type matrix = Matrix<float>
    /// The type of floating point column vectors
    type vector = Vector<float>
    /// The type of floating point row vectors
    type rowvec = RowVector<float>

    /// Create a matrix from lists of floats.  
    val matrix : #seq<#seq<float>>       -> matrix

    /// Create a row vector from lists of floats. 
    val rowvec : #seq<float>            -> rowvec

    /// Create a column vector from lists of floats.
    val vector : #seq<float>            -> vector

    /// Create a matrix from a scalar.  
    val S      : float                 -> matrix

    /// Create a matrix from a column vector.  
    val V      : vector                -> matrix

    /// Convert a matrix to a column vector. 
    val M2V    : matrix                -> vector

    /// Convert a matrix to a scalar.  
    val M2S    : matrix                -> float                

    /// This module contains notation related to matrices and vectors carrying arbitrary element types.
    #if CLI_AT_LEAST_2_0
    module Generic =

        /// Create a complex number x+ij using rectangular coordinates
        val complex : r:float -> i:float -> complex

        /// The type of floating point matrices
        type 'a matrix = Matrix<'a>
        /// The type of floating point column vectors
        type 'a vector = Vector<'a>
        /// The type of floating point row vectors
        type 'a rowvec = RowVector<'a>

        val matrix : #seq<#seq<'a>>     -> Matrix<'a>
        val rowvec : #seq<'a>           -> RowVector<'a>
        val vector : #seq<'a>           -> Vector<'a>
      
        val S      : 'a                 -> Matrix<'a>
        val V      : Vector<'a>         -> Matrix<'a>
      
        val M2V    : Matrix<'a>         -> Vector<'a>
        val M2S    : Matrix<'a>         -> 'a                
#endif
  

