/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import java.io.Serializable;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.expression.Expression;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.execution.RequestContext;

public class ActionResultExposer
implements Serializable {
    private Expression resultExpression;
    private Class expectedResultType;
    private ConversionService conversionService;

    public ActionResultExposer(Expression resultExpression, Class expectedResultType, ConversionService conversionService) {
        Assert.notNull((Object)resultExpression, (String)"The result expression is required");
        if (expectedResultType != null) {
            Assert.notNull((Object)conversionService, (String)"A conversionService is required with an expectedResultType");
        }
        this.resultExpression = resultExpression;
        this.expectedResultType = expectedResultType;
        this.conversionService = conversionService;
    }

    public Expression getNameExpression() {
        return this.resultExpression;
    }

    public Class getExpectedResultType() {
        return this.expectedResultType;
    }

    public void exposeResult(Object result, RequestContext context) {
        this.resultExpression.setValue((Object)context, this.applyTypeConversionIfNecessary(result));
    }

    private Object applyTypeConversionIfNecessary(Object value) {
        if (value == null || this.expectedResultType == null) {
            return value;
        }
        return this.conversionService.getConversionExecutor(value.getClass(), this.expectedResultType).execute(value);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("result", (Object)this.resultExpression).append("resultType", (Object)this.expectedResultType).toString();
    }
}

