/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.core;

import groovy.lang.Closure;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.core.SessionCallback;
import org.grails.datastore.mapping.core.VoidSessionCallback;
import org.grails.datastore.mapping.transactions.SessionHolder;
import org.grails.datastore.mapping.transactions.support.SpringSessionSynchronization;
import org.springframework.core.NamedThreadLocal;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatastoreUtils {
    public static final Log logger = LogFactory.getLog(DatastoreUtils.class);
    private static final ThreadLocal<Map<Datastore, Set<Session>>> deferredCloseHolder = new NamedThreadLocal("Datastore Sessions registered for deferred close");

    public static Session getSession(Datastore datastore, boolean allowCreate) throws DataAccessResourceFailureException, IllegalStateException {
        try {
            return DatastoreUtils.doGetSession(datastore, allowCreate);
        }
        catch (Exception ex) {
            throw new DataAccessResourceFailureException("Could not open Datastore Session", (Throwable)ex);
        }
    }

    public static Session doGetSession(Datastore datastore, boolean allowCreate) {
        Session session;
        Assert.notNull((Object)datastore, (String)"No Datastore specified");
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)datastore));
        if (sessionHolder != null && !sessionHolder.isEmpty()) {
            if (TransactionSynchronizationManager.isSynchronizationActive() && sessionHolder.doesNotHoldNonDefaultSession()) {
                session = sessionHolder.getValidatedSession();
                if (session != null && !sessionHolder.isSynchronizedWithTransaction()) {
                    logger.debug((Object)"Registering Spring transaction synchronization for existing Datastore Session");
                    TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SpringSessionSynchronization(sessionHolder, datastore, false));
                    sessionHolder.setSynchronizedWithTransaction(true);
                }
                if (session != null) {
                    return session;
                }
            } else {
                session = sessionHolder.getValidatedSession();
                if (session != null) {
                    return session;
                }
            }
        }
        logger.debug((Object)"Opening Datastore Session");
        session = datastore.connect();
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            logger.debug((Object)"Registering Spring transaction synchronization for new Datastore Session");
            SessionHolder holderToUse = sessionHolder;
            if (holderToUse == null) {
                holderToUse = new SessionHolder(session);
            } else {
                holderToUse.addSession(session);
            }
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SpringSessionSynchronization(holderToUse, datastore, true));
            holderToUse.setSynchronizedWithTransaction(true);
            if (holderToUse != sessionHolder) {
                TransactionSynchronizationManager.bindResource((Object)datastore, (Object)((Object)holderToUse));
            }
        }
        if (!allowCreate && !DatastoreUtils.isSessionTransactional(session, datastore)) {
            DatastoreUtils.closeSession(session);
            throw new IllegalStateException("No Datastore Session bound to thread, and configuration does not allow creation of non-transactional one here");
        }
        return session;
    }

    public static boolean isSessionTransactional(Session session, Datastore datastore) {
        if (datastore == null) {
            return false;
        }
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)datastore));
        return sessionHolder != null && sessionHolder.containsSession(session);
    }

    public static void closeSession(Session session) {
        if (session == null) {
            return;
        }
        logger.debug((Object)"Closing Datastore Session");
        try {
            session.disconnect();
        }
        catch (Throwable ex) {
            logger.debug((Object)"Unexpected exception on closing Datastore Session", ex);
        }
    }

    public static void releaseSession(Session session, Datastore datastore) {
        if (session == null) {
            return;
        }
        if (!DatastoreUtils.isSessionTransactional(session, datastore)) {
            DatastoreUtils.closeSessionOrRegisterDeferredClose(session, datastore);
        }
    }

    public static void processDeferredClose(Datastore datastore) {
        Assert.notNull((Object)datastore, (String)"No Datastore specified");
        Map<Datastore, Set<Session>> holderMap = deferredCloseHolder.get();
        if (holderMap == null || !holderMap.containsKey(datastore)) {
            throw new IllegalStateException("Deferred close not active for Datastore [" + datastore + "]");
        }
        logger.debug((Object)"Processing deferred close of Datastore Sessions");
        Set<Session> sessions = holderMap.remove(datastore);
        for (Session session : sessions) {
            DatastoreUtils.closeSession(session);
        }
        if (holderMap.isEmpty()) {
            deferredCloseHolder.set(null);
        }
    }

    public static void initDeferredClose(Datastore datastore) {
        Assert.notNull((Object)datastore, (String)"No Datastore specified");
        logger.debug((Object)"Initializing deferred close of Datastore Sessions");
        Map<Datastore, Set<Session>> holderMap = deferredCloseHolder.get();
        if (holderMap == null) {
            holderMap = new HashMap<Datastore, Set<Session>>();
            deferredCloseHolder.set(holderMap);
        }
        holderMap.put(datastore, new LinkedHashSet(4));
    }

    public static void closeSessionOrRegisterDeferredClose(Session session, Datastore datastore) {
        Map<Datastore, Set<Session>> holderMap = deferredCloseHolder.get();
        if (holderMap != null && datastore != null && holderMap.containsKey(datastore)) {
            logger.debug((Object)"Registering Datastore Session for deferred close");
            holderMap.get(datastore).add(session);
        } else {
            DatastoreUtils.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object doWithSession(Datastore datastore, Closure c) {
        boolean existing = datastore.hasCurrentSession();
        Session session = existing ? datastore.getCurrentSession() : DatastoreUtils.bindSession(datastore.connect());
        try {
            Object object = c.call((Object)session);
            return object;
        }
        finally {
            if (!existing) {
                TransactionSynchronizationManager.unbindResource((Object)session.getDatastore());
                DatastoreUtils.closeSessionOrRegisterDeferredClose(session, datastore);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T execute(Datastore datastore, SessionCallback<T> callback) {
        boolean existing = datastore.hasCurrentSession();
        Session session = existing ? datastore.getCurrentSession() : DatastoreUtils.bindSession(datastore.connect());
        try {
            T t = callback.doInSession(session);
            return t;
        }
        finally {
            if (!existing) {
                TransactionSynchronizationManager.unbindResource((Object)session.getDatastore());
                DatastoreUtils.closeSessionOrRegisterDeferredClose(session, datastore);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Datastore datastore, VoidSessionCallback callback) {
        boolean existing = datastore.hasCurrentSession();
        Session session = existing ? datastore.getCurrentSession() : DatastoreUtils.bindSession(datastore.connect());
        try {
            callback.doInSession(session);
        }
        finally {
            if (!existing) {
                TransactionSynchronizationManager.unbindResource((Object)datastore);
                DatastoreUtils.closeSessionOrRegisterDeferredClose(session, datastore);
            }
        }
    }

    public static Session bindSession(Session session) {
        TransactionSynchronizationManager.bindResource((Object)session.getDatastore(), (Object)((Object)new SessionHolder(session)));
        return session;
    }

    public static Session bindNewSession(Session session) {
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)session.getDatastore()));
        if (sessionHolder == null) {
            return DatastoreUtils.bindSession(session);
        }
        sessionHolder.addSession(session);
        return session;
    }

    public static void unbindSession(Session session) {
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)session.getDatastore()));
        if (sessionHolder == null) {
            logger.warn((Object)"Cannot unbind session, there's no SessionHolder registered");
            return;
        }
        if (!sessionHolder.containsSession(session)) {
            logger.warn((Object)"Cannot unbind session, it's not registered in a SessionHolder");
            return;
        }
        if (sessionHolder.size() > 1) {
            sessionHolder.removeSession(session);
        } else {
            TransactionSynchronizationManager.unbindResource((Object)session.getDatastore());
        }
        DatastoreUtils.closeSessionOrRegisterDeferredClose(session, session.getDatastore());
    }
}

