/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.proxy;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyObject;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.proxy.EntityProxy;
import org.grails.datastore.mapping.proxy.ProxyFactory;
import org.grails.datastore.mapping.reflect.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavassistProxyFactory
implements ProxyFactory {
    private static final Map<Class, Class> PROXY_FACTORIES = new ConcurrentHashMap<Class, Class>();
    private static final List EXCLUDES = Arrays.asList("getMetaClass", "metaClass", "setMetaClass", "invokeMethod", "getProperty", "setProperty", "$getStaticMetaClass");

    @Override
    public boolean isProxy(Object object) {
        return object instanceof EntityProxy;
    }

    @Override
    public Serializable getIdentifier(Object obj) {
        return ((EntityProxy)obj).getProxyKey();
    }

    @Override
    public boolean isInitialized(Object object) {
        return !this.isProxy(object) || ((EntityProxy)object).isInitialized();
    }

    @Override
    public Object unwrap(Object object) {
        if (this.isProxy(object)) {
            return ((EntityProxy)object).getTarget();
        }
        return object;
    }

    @Override
    public <T> T createProxy(Session session, Class<T> type, Serializable key) {
        return (T)this.getProxyInstance(session, type, key);
    }

    protected Object createProxiedInstance(final Session session, final Class cls, Class proxyClass, final Serializable id) {
        MethodHandler mi = new MethodHandler(){
            private Object target;

            public Object invoke(Object proxy, Method method, Method proceed, Object[] args) throws Throwable {
                if (args.length == 0) {
                    String methodName = method.getName();
                    if (methodName.equals("getId") || methodName.equals("getProxyKey")) {
                        return id;
                    }
                    if (methodName.equals("initialize")) {
                        this.initialize();
                        return null;
                    }
                    if (methodName.equals("isInitialized")) {
                        return this.target != null;
                    }
                    if (methodName.equals("getTarget")) {
                        this.initialize();
                        return this.target;
                    }
                }
                if (this.target == null) {
                    this.initialize();
                }
                return org.springframework.util.ReflectionUtils.invokeMethod((Method)method, (Object)this.target, (Object[])args);
            }

            public void initialize() {
                this.target = session.retrieve(cls, id);
            }
        };
        Object proxy = ReflectionUtils.instantiate(proxyClass);
        ((ProxyObject)proxy).setHandler(mi);
        return proxy;
    }

    protected Object getProxyInstance(Session session, Class type, Serializable id) {
        Class proxyClass = this.getProxyClass(type);
        return this.createProxiedInstance(session, type, proxyClass, id);
    }

    protected Class getProxyClass(Class type) {
        Class proxyClass = PROXY_FACTORIES.get(type);
        if (proxyClass == null) {
            javassist.util.proxy.ProxyFactory pf = new javassist.util.proxy.ProxyFactory();
            pf.setSuperclass(type);
            pf.setInterfaces(new Class[]{EntityProxy.class});
            pf.setFilter(new MethodFilter(){

                public boolean isHandled(Method method) {
                    String methodName = method.getName();
                    if (methodName.indexOf("super$") > -1) {
                        return false;
                    }
                    if (method.getParameterTypes().length == 0 && methodName.equals("finalize")) {
                        return false;
                    }
                    return !EXCLUDES.contains(methodName) && !method.isSynthetic() && !method.isBridge();
                }
            });
            proxyClass = pf.createClass();
            PROXY_FACTORIES.put(type, proxyClass);
        }
        return proxyClass;
    }
}

