/*
 * Decompiled with CFR 0.152.
 */
package sl.org.objectweb.asm.util;

import sl.org.objectweb.asm.AnnotationVisitor;
import sl.org.objectweb.asm.Type;
import sl.org.objectweb.asm.util.TraceAbstractVisitor;

public class TraceAnnotationVisitor
extends TraceAbstractVisitor
implements AnnotationVisitor {
    protected AnnotationVisitor av;
    private int valueNumber = 0;

    public void visit(String string, Object object) {
        this.buf.setLength(0);
        this.appendComa(this.valueNumber++);
        if (string != null) {
            this.buf.append(string).append('=');
        }
        if (object instanceof String) {
            this.visitString((String)object);
        } else if (object instanceof Type) {
            this.visitType((Type)object);
        } else if (object instanceof Byte) {
            this.visitByte((Byte)object);
        } else if (object instanceof Boolean) {
            this.visitBoolean((Boolean)object);
        } else if (object instanceof Short) {
            this.visitShort((Short)object);
        } else if (object instanceof Character) {
            this.visitChar(((Character)object).charValue());
        } else if (object instanceof Integer) {
            this.visitInt((Integer)object);
        } else if (object instanceof Float) {
            this.visitFloat(((Float)object).floatValue());
        } else if (object instanceof Long) {
            this.visitLong((Long)object);
        } else if (object instanceof Double) {
            this.visitDouble((Double)object);
        } else if (object.getClass().isArray()) {
            this.buf.append('{');
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                for (int i = 0; i < byArray.length; ++i) {
                    this.appendComa(i);
                    this.visitByte(byArray[i]);
                }
            } else if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                for (int i = 0; i < blArray.length; ++i) {
                    this.appendComa(i);
                    this.visitBoolean(blArray[i]);
                }
            } else if (object instanceof short[]) {
                short[] sArray = (short[])object;
                for (int i = 0; i < sArray.length; ++i) {
                    this.appendComa(i);
                    this.visitShort(sArray[i]);
                }
            } else if (object instanceof char[]) {
                char[] cArray = (char[])object;
                for (int i = 0; i < cArray.length; ++i) {
                    this.appendComa(i);
                    this.visitChar(cArray[i]);
                }
            } else if (object instanceof int[]) {
                int[] nArray = (int[])object;
                for (int i = 0; i < nArray.length; ++i) {
                    this.appendComa(i);
                    this.visitInt(nArray[i]);
                }
            } else if (object instanceof long[]) {
                long[] lArray = (long[])object;
                for (int i = 0; i < lArray.length; ++i) {
                    this.appendComa(i);
                    this.visitLong(lArray[i]);
                }
            } else if (object instanceof float[]) {
                float[] fArray = (float[])object;
                for (int i = 0; i < fArray.length; ++i) {
                    this.appendComa(i);
                    this.visitFloat(fArray[i]);
                }
            } else if (object instanceof double[]) {
                double[] dArray = (double[])object;
                for (int i = 0; i < dArray.length; ++i) {
                    this.appendComa(i);
                    this.visitDouble(dArray[i]);
                }
            }
            this.buf.append('}');
        }
        this.text.add(this.buf.toString());
        if (this.av != null) {
            this.av.visit(string, object);
        }
    }

    private void visitInt(int n) {
        this.buf.append(n);
    }

    private void visitLong(long l) {
        this.buf.append(l).append('L');
    }

    private void visitFloat(float f) {
        this.buf.append(f).append('F');
    }

    private void visitDouble(double d) {
        this.buf.append(d).append('D');
    }

    private void visitChar(char c) {
        this.buf.append("(char)").append((int)c);
    }

    private void visitShort(short s) {
        this.buf.append("(short)").append(s);
    }

    private void visitByte(byte by) {
        this.buf.append("(byte)").append(by);
    }

    private void visitBoolean(boolean bl) {
        this.buf.append(bl);
    }

    private void visitString(String string) {
        TraceAnnotationVisitor.appendString(this.buf, string);
    }

    private void visitType(Type type) {
        this.buf.append(type.getClassName()).append(".class");
    }

    public void visitEnum(String string, String string2, String string3) {
        this.buf.setLength(0);
        this.appendComa(this.valueNumber++);
        if (string != null) {
            this.buf.append(string).append('=');
        }
        this.appendDescriptor(1, string2);
        this.buf.append('.').append(string3);
        this.text.add(this.buf.toString());
        if (this.av != null) {
            this.av.visitEnum(string, string2, string3);
        }
    }

    public AnnotationVisitor visitAnnotation(String string, String string2) {
        this.buf.setLength(0);
        this.appendComa(this.valueNumber++);
        if (string != null) {
            this.buf.append(string).append('=');
        }
        this.buf.append('@');
        this.appendDescriptor(1, string2);
        this.buf.append('(');
        this.text.add(this.buf.toString());
        TraceAnnotationVisitor traceAnnotationVisitor = this.createTraceAnnotationVisitor();
        this.text.add(traceAnnotationVisitor.getText());
        this.text.add(")");
        if (this.av != null) {
            traceAnnotationVisitor.av = this.av.visitAnnotation(string, string2);
        }
        return traceAnnotationVisitor;
    }

    public AnnotationVisitor visitArray(String string) {
        this.buf.setLength(0);
        this.appendComa(this.valueNumber++);
        if (string != null) {
            this.buf.append(string).append('=');
        }
        this.buf.append('{');
        this.text.add(this.buf.toString());
        TraceAnnotationVisitor traceAnnotationVisitor = this.createTraceAnnotationVisitor();
        this.text.add(traceAnnotationVisitor.getText());
        this.text.add("}");
        if (this.av != null) {
            traceAnnotationVisitor.av = this.av.visitArray(string);
        }
        return traceAnnotationVisitor;
    }

    public void visitEnd() {
        if (this.av != null) {
            this.av.visitEnd();
        }
    }

    private void appendComa(int n) {
        if (n != 0) {
            this.buf.append(", ");
        }
    }
}

